%define subver %nil

%def_enable a52
%def_enable imagemagick
%def_enable libdv
%def_enable libdvdread
%def_enable libfame
%def_enable libjpeg
%def_disable libquicktime
%def_enable libxml2
%def_enable lzo
%def_enable mjpegtools
%def_enable mmx
%def_enable netstream
%def_enable ogg
%def_enable sdl
%def_enable theora
%def_enable v4l
%def_enable vorbis
%def_enable libpostproc
%def_enable freetype2
%def_enable xvid
%def_enable x264
%def_disable pvm3
%def_enable libmpeg2
%def_enable alsa
%def_disable avifile
%def_disable ibp
%def_disable libmpeg3
%def_disable xio

Name: transcode
Version: 1.1.7
Release: alt12

Summary: A linux video stream processing utility

License: GPL
Group: Video
Url: http://bitbucket.org/france/transcode-tcforge/

Source: %name-%version.tar
Source1: subtitleripper-0.3-4.tar
Source2: export_dvraw.c
Patch0: %name-subtitleripper.patch
# http://article.gmane.org/gmane.comp.video.transcode.user/18434
# http://article.gmane.org/gmane.comp.video.transcode.user/18381
# http://article.gmane.org/gmane.comp.video.transcode.user/18446
# Gentoo
Patch10: transcode-1.1.7-ffmpeg.patch
Patch11: transcode-1.1.7-ffmpeg-0.10.patch
Patch12: transcode-1.1.7-ffmpeg-0.11.patch
Patch13: transcode-1.1.7-preset-free.patch
Patch14: transcode-1.1.7-libav-9.patch
Patch15: transcode-1.1.7-preset-force.patch
Patch16: transcode-1.1.7-ffmpeg2.patch
Patch17: transcode-1.1.7-freetype251.patch
Patch18: transcode-1.1.7-ffmpeg24.patch
Patch19: transcode-1.1.7-ffmpeg4.patch
# rpmfusion
Patch20: transcode-1.1.7-ffmpeg29.patch
# Debian
Patch21: transcode-1.7.7-debian-underlinkage.patch
# ALTLinux patches
Patch96: transcode-1.1.7-libav-10.patch
Patch98: transcode-1.1.5-textrel.patch
Patch99: subtitleripper-0.3-4-alt-makefile.patch
Patch100: transcode-1.1.7-alt-fix-plugin-import_ac3-undefined-symbol.patch

%define ffmpeg_ver 0.6
%define avifile_ver 0.737
%define xvid_ver 1.2.2
%define exif_ver 0.6.17

#BuildRequires: glibc-devel-static imake libImageMagick-devel libSDL-devel libXaw-devel libXpm-devel libXv-devel liba52-devel libalsa-devel libavformat-devel libdvdread-devel libfreetype-devel liblame-devel liblzo2-devel libmjpegtools-devel libmpeg2-devel libnetpbm-devel libpostproc-devel libquicktime-devel libtheora-devel libv4l-devel libx264-devel libxml2-devel libxvid-devel rpm-build-ruby xorg-cf-files
BuildRequires: glibc-devel imake libImageMagick-devel libSDL-devel libXaw-devel libXpm-devel
BuildRequires: libXv-devel liba52-devel libalsa-devel
BuildRequires: libavformat-devel libdvdread-devel libfreetype-devel liblame-devel liblzo2-devel
BuildRequires: libmjpegtools-devel libmpeg2-devel libnetpbm-devel libpostproc-devel libswscale-devel
BuildRequires: libtheora-devel libv4l-devel libx264-devel libxml2-devel
BuildRequires: libavresample-devel libxvid-devel >= %xvid_ver xorg-cf-files
%if_enabled libdv
BuildRequires: libdv-devel
%endif
%if_enabled libjpeg
BuildRequires: libjpeg-devel
%endif
%if_enabled libquicktime
BuildRequires: libquicktime-devel
%endif
%if_enabled vorbis
BuildRequires: libvorbis-devel
%endif
BuildPreReq: libpng-devel

%description
transcode  is a linux text-console utility for video stream
processing.

Decoding and encoding is done by loading modules that are
responsible for feeding transcode with raw video/audio streams (import
modules) and encoding the frames (export modules).

It supports elementary video and audio frame transformations, including
de-interlacing or fast resizing of video frames and loading of external
filters.

A number of modules are included to enable import of DVDs
on-the-fly, MPEG elementary (ES) or program streams (VOB), MPEG video,
Digital Video (DV), YUV4MPEG streams, NuppelVideo file format and raw or
compressed (pass-through) video frames and export modules for writing
DivX;-), OpenDivX, DivX 4.xx or uncompressed AVI files with MPEG, AC3
(pass-through) or PCM audio. Additional export modules to write single
frames (PPM) or YUV4MPEG streams are available, as well as an interface
import module to the avifile library. It's modular concept is intended
to provide flexibility and easy user extensibility to include other
video/audio codecs or filetypes.

A set of tools is included to demux (tcdemux), extract (tcextract) and
decode (tcdecode) the sources into raw video/audio streams for import,
probing (tcprobe) and scanning (tcscan) your sources and to enable
post-processing of AVI files, fixing AVI file header information
(avifix), merging multiple files (avimerge) or splitting large AVI files
(avisplit) to fit on a CD.

%package -n subtitleripper
Summary: DVD subtitles ripper/converter
Group: Video
Requires: %name

%description -n subtitleripper
This package contains tools to extract DVD subtitles from a
subtitle stream and converts it to pgm or ppm images or into VobSub
format.

%prep
%setup -q -n %name-%{version}%{subver}
mkdir -p contrib/subrip
tar xf %SOURCE1 -C contrib/subrip/
sed -i s/-lppm/-lnetpbm/ contrib/subrip/subtitleripper/Makefile
sed -i s/getline/get_line/ contrib/subrip/subtitleripper/vobsub.c
%patch0 -p0
#
%patch10 -p0
%patch11 -p0
%patch12 -p1
%patch13 -p1
%patch14 -p0
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1
%patch19 -p1
%patch20 -p1
%patch21 -p1
#
%patch96 -p1
%patch98 -p2
%patch99 -p1
%patch100 -p1
install -m644 %SOURCE2 filter/

%build
sed -i 's,strtof ,,' configure.in
%autoreconf
%add_optflags -fpie -D_LARGEFILE_SOURCE -D__USE_LARGEFILE -D_FILE_OFFSET_BITS=64
export LDFLAGS=-pie
%configure \
--enable-experimental \
--enable-deprecated \
--disable-x86-textrels \
%{subst_enable mmx} \
%{subst_enable a52} \
%if_enabled a52
--enable-a52-default-decoder \
%endif
%{subst_enable avifile} \
%{subst_enable ibp} \
%{subst_enable imagemagick} \
%{subst_enable libdv} \
%{subst_enable libdvdread} \
%{subst_enable libfame} \
%if_enabled libfame
--with-libfame-libs=/usr/lib \
%endif
%{subst_enable libjpeg} \
%{subst_enable libmpeg3} \
%{subst_enable libquicktime} \
%{subst_enable libxml2} \
%{subst_enable lzo} \
%{subst_enable mjpegtools} \
%{subst_enable netstream} \
%{subst_enable ogg} \
%{subst_enable pvm3} \
%{subst_enable sdl} \
%{subst_enable theora} \
%if_enabled v4l
--enable-v4l \
--enable-libv4l2 \
--enable-libv4lconvert \
%endif
%{subst_enable vorbis} \
%{subst_enable libpostproc} \
%{subst_enable alsa} \
%{subst_enable xvid} \
%{subst_enable x264} \
%if_enabled libmpeg2
--enable-libmpeg2 \
--enable-libmpeg2convert \
%endif
%{subst_enable freetype2} \
#

%make_build

pushd contrib/subrip/subtitleripper
%make INCLUDES=-I/usr/include/netpbm
popd

%install
%makeinstall
pushd contrib/subrip/subtitleripper
install -m755 \
srttool \
subtitle2pgm \
subtitle2vobsub \
pgm2txt %buildroot/%_bindir/
popd

# remove non-packaged files
rm -f %buildroot%_libdir/%name/*.la
rm -rf %buildroot%_docdir/%name

# The package contains a CVS/.svn/.git/.hg/.bzr/_MTN directory of revision control system.
# It was most likely included by accident since CVS/.svn/.hg/... etc. directories 
# usually don't belong in releases. 
# When packaging a CVS/SVN snapshot, export from CVS/SVN rather than use a checkout.
find $RPM_BUILD_ROOT -type d \( -name 'CVS' -o -name '.svn' -o -name '.git' -o -name '.hg' -o -name '.bzr' -o -name '_MTN' \) -print -exec rm -rf {} \; ||:
# the find below is useful in case those CVS/.svn/.git/.hg/.bzr/_MTN directory is added as %%doc
find . -type d \( -name 'CVS' -o -name '.svn' -o -name '.git' -o -name '.hg' -o -name '.bzr' -o -name '_MTN' \) -print -exec rm -rf {} \; ||:

export RPM_LD_PRELOAD_transcode='%buildroot%_bindir/transcode %buildroot%_bindir/tcdecode'
export RPM_FILES_TO_LD_PRELOAD_transcode='%_libdir/%name/*.so'
%set_verify_elf_method strict

%files
%_bindir/%name
%_bindir/avi*
%_bindir/tc*
%dir %_libdir/%name
%_libdir/%name/*.so
%_libdir/%name/*.cfg
%_libdir/%name/*.awk
%_datadir/%name/
%_man1dir/*
%doc AUTHORS ChangeLog README TODO
%doc docs/README*
%doc docs/*.txt docs/html

%files -n subtitleripper
%_bindir/srttool
%_bindir/subtitle2pgm
%_bindir/subtitle2vobsub
%_bindir/pgm2txt
%doc contrib/subrip/subtitleripper/{README*,ChangeLog}

%changelog
