Group: File tools
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/bison /usr/bin/flex /usr/bin/import /usr/bin/inkscape /usr/bin/kpsewhich /usr/bin/xelatex perl(English.pm) perl(open.pm)
# END SourceDeps(oneline)
BuildRequires: chrpath
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           ttfautohint
Version:        1.8.2
Release:        alt1_2
Summary:        Automated hinting utility for TrueType fonts
License:        FTL or GPLv2
URL:            http://www.freetype.org/ttfautohint
Source0:        http://download.savannah.gnu.org/releases/freetype/%{name}-%{version}.tar.gz
# https://bugzilla.redhat.com/1646687
Patch0:         f18b7c859c92111446ca991743dd709e347d0301.patch

BuildRequires:  gcc gcc-c++
BuildRequires:  libfreetype-devel
BuildRequires:  libharfbuzz-devel libharfbuzz-utils
BuildRequires:  qt5-base-devel
Provides:       bundled(gnulib)
Requires:       %{name}-libs = %{version}-%{release}
Source44: import.info

%description
This is a utility which takes a TrueType font as the input, removes its 
bytecode instructions (if any), and returns a new font where all glyphs 
are bytecode hinted using the information given by FreeType's autohinting 
module. The idea is to provide the excellent quality of the autohinter on 
platforms which don't use FreeType.

%package        gui
Group: File tools
Summary:        GUI for %{name} based on Qt
Requires:       %{name}-libs = %{version}-%{release}

%description    gui
%{name} is a utility which takes a TrueType font as the input, removes its 
bytecode instructions (if any), and returns a new font where all glyphs 
are bytecode hinted using the information given by FreeType's autohinting 
module. The idea is to provide the excellent quality of the autohinter on 
platforms which don't use FreeType.

This is a GUI of %{name} based on Qt. 

%package        libs
Group: File tools
Summary:        Library for %{name}

%description    libs
lib%{name} is a library which takes a TrueType font as the input, removes its 
bytecode instructions (if any), and returns a new font where all glyphs 
are bytecode hinted using the information given by FreeType's autohinting 
module. The idea is to provide the excellent quality of the autohinter on 
platforms which don't use FreeType.

%package        devel
Group: File tools
Summary:        Development files for %{name}-libs
Requires:       %{name}-libs = %{version}-%{release}

%description    devel
lib%{name} is a library which takes a TrueType font as the input, removes its 
bytecode instructions (if any), and returns a new font where all glyphs 
are bytecode hinted using the information given by FreeType's autohinting 
module. The idea is to provide the excellent quality of the autohinter on 
platforms which don't use FreeType.


%prep
%setup -q
%patch0 -p1

%build
%configure --disable-silent-rules --disable-static
%make_build

%install
%makeinstall_std

find %{buildroot} -name '*.la' -delete
# kill rpath
for i in `find %buildroot{%_bindir,%_libdir,/usr/libexec,/usr/lib,/usr/sbin} -type f -perm -111 ! -name '*.la' `; do
	chrpath -d $i ||:
done



%files
%doc AUTHORS NEWS README THANKS TODO *.TXT
%doc doc/img doc/ttfautohint.html
%doc doc/img doc/ttfautohint.pdf
%doc doc/img doc/ttfautohint.txt
%doc --no-dereference COPYING
%{_bindir}/ttfautohint

%files gui
%doc --no-dereference COPYING
%{_bindir}/ttfautohintGUI

%files libs
%doc --no-dereference COPYING
%{_libdir}/libttfautohint.so.1*

%files devel
%doc --no-dereference COPYING
%{_includedir}/ttfautohint*.h
%{_libdir}/libttfautohint.so
%{_libdir}/pkgconfig/ttfautohint.pc

%changelog
