Name: tuxpaint
Version: 0.9.23
Release: alt2

Summary: A drawing program for young children
Summary(ru_RU.UTF8): Простая детская программа для рисования

License: GPL
Group: Graphics
Url: http://www.tuxpaint.org/

Source: %name-%version.tar.gz
Source1: %name.desktop

Patch: kdelibs4-removal.patch

BuildRequires: libSDL-devel >= 1.2.4 libSDL_image-devel libSDL_mixer-devel libSDL_pango-devel libSDL_ttf-devel
BuildRequires: libpng-devel zlib-devel gettext librsvg-devel libpaper-devel libfribidi-devel
BuildPreReq: gperf

%description
"Tux Paint" is a drawing program for young children.
It provides a simple interface and fixed canvas size,
and provides access to previous images using a thumbnail
browser (e.g., no access to the underlying file-system).

Unlike popular drawing programs like "The GIMP," it has a
very limited tool-set. However, it provides a much simpler
interface, and has entertaining, child-oriented additions
such as sound effects.

%description -l ru_RU.UTF8
"Tux Paint" является детской программой для рисования.
Она предоставляет простой интерфейс и фиксированый размер холста,
и позволяет просматривать изображениям, используя "thumbnail" браузер
(т.е., нет необходимости иметь доступ к основной файловой системе).

В отличие от популярных программ для рисования таких как "The GIMP",
она имеет очень ограниченный набор инструментов. Однако, это обеспечивает
намного более простой интерфейс, и имеет интересные, ориентированные на 
ребенка дополнения, типа звуковых эффектов.

Входит в состав GCompris. Также может использываться отдельно

%package devel
Summary: Development shared library for %name
Group: Development/C
Requires: %name = %version-%release
%description devel
Development shared library for %name

%prep
%setup
%patch -p1

subst "s|\$(PREFIX)/lib|%_libdir|g" Makefile
subst "s|< \$(PLUGIN_LIBS)|< \$(PLUGIN_LIBS) \$(SDL_LIBS) \$(PNG)|g" Makefile
sed -i '/^linux_ARCH_LINKS/s/\$(FRIBIDI_LIB)/\$(FRIBIDI_LIB) \$(PNG)/g' Makefile
sed -i 's|^\(CFLAGS\).*=\(.*\))|\1 = -g \2|' Makefile

%build
%make PREFIX=/usr MAGIC_PREFIX=%_libdir/%name/plugins

%install
%make install PREFIX=/usr \
    PKG_ROOT=%buildroot \
    MAGIC_PREFIX=%buildroot%_libdir/%name/plugins \
    X11_ICON_PREFIX=%buildroot%_datadir/pixmaps/ \
    GNOME_PREFIX=/usr \
    KDE_PREFIX="" \
    KDE_ICON_PREFIX=/usr/share/icons \
    DEVDOC_PREFIX=%buildroot%_defaultdocdir/%name-devel-%version

%find_lang %name

# Add tuxpaint.desktop
install -d %buildroot%_datadir/applications
cp -aRf %SOURCE1 %buildroot%_datadir/applications/

# Remove fonts (see ALT 25339)
rm -f /usr/share/tuxpaint/fonts/Free*.ttf

%files -f %name.lang
# bin files
%_bindir/tuxpaint*
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/%name.conf
%_libdir/%name


# docs files
%_docdir/%name-%version
%_man1dir/tuxpaint*

# data files
%_datadir/%name
%_datadir/applications/*
%_iconsdir/hicolor/*/*/*

# menu
%_datadir/pixmaps/*

%files devel
%_bindir/tp-magic-config
%_includedir/%name
%_docdir/%name-devel-%version
%_man1dir/tp-magic-config*

%changelog
