BuildRequires: desktop-file-utils
%define oname tuxtype_w_fonts
Name: tuxtype
Version: 1.8.1
Release: alt1.qa1

Summary: An educational typing tutor game starring Tux

Group: Games/Educational
License: GPLv2
Url: http://tux4kids.alioth.debian.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: %oname-%version.tar.gz
Source1: %name-48x48.xpm
Source2: %name-32x32.xpm
Source3: %name-16x16.xpm
Source4: ru.po
Patch1:  %name-fix-install.patch

BuildRequires: libSDL-devel libSDL_image-devel libSDL_mixer-devel libSDL_ttf-devel libSDL_pango-devel
BuildRequires: librsvg-devel

%description
Educational typing tutor starring Tux, the Linux Penguin. Object of
the game is to catch fish as they drop from the top of the screen.
Each fish has a letter or a word written on it, and Tux eats the fish
by the player pressing the associated key or typing the appropriate
word. Intended to be cute and fun for children learning to type and
spell.

%prep
%setup -q -n %oname-%version
cp %SOURCE4 po/
%patch1 -p2

%build
#%configure --without-sdlpango --without-rsvg --prefix=/usr --exec-prefix=/usr --sysconfdir=/usr/share/tuxtype/etc/ --localstatedir=/usr/share/tuxtype/var/
%configure --localstatedir=%_localstatedir/games --sysconfdir=%_sysconfdir
%make_build

%install
%makeinstall_std

mkdir -p %buildroot%_localstatedir/games/tuxtype

mkdir -p %buildroot%_desktopdir/
cat <<EOF > %buildroot%_desktopdir/%name.desktop
[Desktop Entry]
Name=Tux Typing
Comment=An educational typing tutor game starring Tux
Comment[ru]=Играй и учись печатать
Exec=%name
Icon=%name
Terminal=false
Type=Application
Categories=Game;Application;
EOF

install -pD -m644 %SOURCE1 %buildroot%_liconsdir/%name.xpm
install -pD -m644 %SOURCE2 %buildroot%_niconsdir/%name.xpm
install -pD -m644 %SOURCE3 %buildroot%_miconsdir/%name.xpm

%find_lang %name
rm -rf %buildroot%_docdir/%name/
rm -rf %buildroot%_prefix/doc/
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=KidsGame \
	--add-category=X-Typing \
	%buildroot%_desktopdir/tuxtype.desktop

%files -f %name.lang
%doc README AUTHORS TODO ChangeLog doc/OFL
%_bindir/%name
%_datadir/%name/
%_niconsdir/%name.xpm
%_liconsdir/%name.xpm
%_miconsdir/%name.xpm
%_desktopdir/%name.desktop
%config(noreplace) %_sysconfdir/tuxtype
%attr(0755,root,games) %config(noreplace) %_localstatedir/games/tuxtype

%changelog
