Name: u-boot-rockchip
Version: 2021.01
Release: alt1

Summary: Das U-Boot
License: GPLv2+
Group: System/Kernel and hardware

ExclusiveArch: aarch64

Source: %name-%version-%release.tar

BuildRequires: atf-rockchip >= 2.4
BuildRequires: bc ccache dtc >= 1.4 flex
BuildRequires: python3-dev swig
BuildRequires: python3(pkg_resources)
BuildRequires: python3(elftools.elf.elffile)

%description
boot loader for embedded boards based on PowerPC, ARM, MIPS and several
other processors, which can be installed in a boot ROM and used to
initialize and test the hardware or to download and run application code.
This package supports various Rockchip RK3399 based boards.

%prep
%setup
egrep -lr 'CONFIG_ROCKCHIP_(PX30|RK3328|RK3399)' configs |xargs sed -i \
	-e '/^CONFIG_DEFAULT_FDT_FILE/ s,rockchip/,,' \
	-e '/^CONFIG_BAUDRATE/ s,1500000,115200,'
sed -E '/^CONFIG_DEFAULT_FDT_FILE=/ s,=.+$,="rk3399-sapphire-excavator.dtb",' \
	< configs/evb-rk3399_defconfig > configs/rk3399-sapphire-excavator_defconfig

%build
export PYTHON=python3

buildit()
{
  mkdir build
  BL31=%_datadir/atf/$1/bl31.elf \
  %make_build O=build ${board}_defconfig all
  install -pm0644 -D build/u-boot.itb out/${board}/u-boot.itb
  install -pm0644 build/idbloader.img out/${board}/
  install -pm0644 build/u-boot-rockchip.bin out/${board}/
  rm -rf build
}

for soc in PX30 RK3328 RK3399; do
boards=$(fgrep -lr CONFIG_ROCKCHIP_${soc} configs |sed 's,^configs/\(.\+\)_defconfig,\1,')
for board in $boards; do buildit ${soc,,[A-Z]}; done
done

%install
mkdir -p %buildroot%_datadir/u-boot
cd out 
find . -type f | cpio -pmd %buildroot%_datadir/u-boot

%files
%doc README doc/README.rockchip doc/board/rockchip
%_datadir/u-boot/*

%changelog
