Name: u-boot-sunxi
Version: 2021.01
Release: alt2

Summary: Das U-Boot
License: GPLv2+
Group: System/Kernel and hardware
Url: http://linux-sunxi.org/U-Boot

ExclusiveArch: armh aarch64

Source: %name-%version-%release.tar

Provides: u-boot-sunxi64 = %version-%release
Obsoletes: u-boot-sunxi64

%ifarch aarch64
%define ATF atf-sunxi >= 2.4
%else
%define ATF %nil
%endif

BuildRequires: %ATF bc ccache dtc >= 1.4 flex
BuildRequires: python3-dev swig
BuildRequires: python3(pkg_resources)

%description
boot loader for embedded boards based on PowerPC, ARM, MIPS and several
other processors, which can be installed in a boot ROM and used to
initialize and test the hardware or to download and run application code.
This package supports boards based on Allwinner SoCs.

See http://linux-sunxi.org/Bootable_SD_card#Bootloader for details.

%prep
%setup

%build
export PYTHON=python3
%ifarch aarch64
boards=$(grep -lr MACH_SUN50I configs |sed 's,^configs/\(.\+\)_defconfig,\1,')
%else
boards=$(grep -lr 'MACH_SUN[4-9]I' configs |sed 's,^configs/\(.\+\)_defconfig,\1,')
%endif
for board in $boards; do
	mkdir build
%ifarch aarch64
	fgrep -q SUN50I_H6 configs/${board}_defconfig && \
		export BL31=%_datadir/atf/sun50i_h6/bl31.bin || \
		export BL31=%_datadir/atf/sun50i_a64/bl31.bin
%endif
	%make_build HOSTCC='ccache gcc' CC='ccache gcc' O=build ${board}_defconfig all
	install -pm0644 -D build/u-boot-sunxi-with-spl.bin out/${board}/u-boot-sunxi-with-spl.bin
	rm -rf build
done

%install
mkdir -p %buildroot%_datadir/u-boot
cd out
find . -type f | cpio -pmd %buildroot%_datadir/u-boot

%files
%doc README README.sunxi board/sunxi/README.sunxi64
%_datadir/u-boot/*

%changelog
