%define abiversion 2
# only included for backwards compatibility, gui now in its own project, see ChangeLog
%def_without qt

Name:    unixODBC
Version: 2.3.7
Release: alt1

Summary: Unix ODBC driver manager and database drivers
Summary(ru_RU.UTF-8): Система управления драйверами ODBC для unix 
Group: Databases
License: LGPL
Url: http://www.unixODBC.org

Requires: lib%name%abiversion = %version-%release
Provides: MyODBC = %version-%release
Provides:  unixodbc = %version-%release
Obsoletes: unixodbc < %version-%release

Source0: http://www.unixodbc.org/%name-%version.tar.gz

Source1: %name-odbcinst.ini
Source2: %name-DataManager.desktop
Source3: %name-ODBCConfig.desktop

Patch1: %name-depcomp.patch
Patch4: %name-2.2.11-symbols.patch
Patch5: %name-remove-rpath-to-libdir.patch
# Patches from Fedora
Patch11: keep-typedefs.patch
Patch12: so-version-bump.patch

%{?_with_qt:BuildRequires(pre): qt4-devel}
BuildRequires: flex gcc-c++ libltdl7-devel libreadline-devel
BuildRequires: chrpath

%description
UnixODBC is a free/open and solution for ODBC. ODBC is an open
specifican for providing application developers with a predictable API
with which to access Data Sources. Data Sources include SQL Servers and
any Data Source with an ODBC Driver.
You will also need the mysql-connector-odbc package if you want to
access a MySQL database, and/or the postgresql-odbc package for
PostgreSQL.

%description -l ru_RU.UTF-8
UnixODBC - это свободное ODBC-решение.
ODBC представляет из себя открытую спецификацию для разработки
приложений с универсальным API для доступа к базам данных.
Базы данных включает в себя серверы SQL и другие источники данных,
поддерживаемые ODBC-драйверами.

%package -n lib%name%abiversion
Summary: Shared libraries for ODBC
Summary(ru_RU.UTF-8): Разделяемые библиотеки для ODBC
Group: Development/Databases
Provides:  libunixodbc%abiversion = %version-%release
Obsoletes: libunixodbc%abiversion < %version-%release

%description -n lib%name%abiversion
unixODBC aims to provide a complete ODBC solution for the Linux
platform.  This package contains the shared libraries.

%description -n lib%name%abiversion -l ru_RU.UTF-8
unixODBC представляет из себя полную спецификацию ODBC для Linux
платформы.  Этот пакет содержит в себе разделяемые библиотеки.

%package -n lib%name-devel-compat
Summary: Compat libraries for Java build
Group: Development/Databases
Conflicts: lib%{name}1 < 2.2.12-alt8
Provides:  lib%name = %version-%release
Obsoletes: lib%name < %version-%release
%ifarch x86_64
Provides: libodbc.so()(64bit) libodbcinst.so()(64bit)
%else
Provides: libodbc.so libodbcinst.so
%endif

%description -n lib%name-devel-compat
Compat libraries for Java build.

%package -n lib%name-devel
Summary: Includes for ODBC development
Summary(ru_RU.UTF-8): Заголовочные файлы для разработки с использованием ODBC
Group: Development/Databases
Requires: lib%name%abiversion = %version-%release
Requires: lib%name-devel-compat = %version-%release

%description -n lib%name-devel
unixODBC aims to provide a complete ODBC solution for the Linux
platform.  This package contains the include files for development.

%description -n lib%name-devel -l ru_RU.UTF-8
unixODBC представляет из себя полную спецификацию ODBC для Linux
платформы.  Этот пакет содержит заголовочные файлы для разработки с
использованием ODBC

%prep
%setup -q
%patch4 -p1
%patch5 -p2
%patch11 -p1
%patch12 -p1

chmod 0644 Drivers/MiniSQL/*.c
chmod 0644 Drivers/nn/*.c
chmod 0644 Drivers/template/*.c
chmod 0644 doc/ProgrammerManual/Tutorial/*.html
chmod 0644 doc/lst/*
chmod 0644 include/odbcinst.h

# Blow away the embedded libtool and replace with build system's libtool.
# (We will use the installed libtool anyway, but this makes sure they match.)
rm -rf config.guess config.sub install-sh ltmain.sh libltdl compile depcomp missing
# this hack is so we can build with either libtool 2.2 or 1.5
libtoolize --install || libtoolize
rm libltdl/config-h.in
cp %_datadir/libtool/libltdl/config-h.in libltdl/config-h.in

%build
%if_with qt
export QTDIR=%_qt4dir
%endif
aclocal
automake --add-missing
autoconf

# unixODBC 2.2.14 is not aliasing-safe
CFLAGS="%{optflags} -fno-strict-aliasing"
CXXFLAGS="$CFLAGS"
export CFLAGS CXXFLAGS

%configure \
	--with-gnu-ld \
	:	--enable-threads \
	--enable-drivers \
	--enable-driverc \
	--enable-ltdllib \
%if_with qt
	--enable-gui \
	--with-qt-libraries=%_qt4dir/lib \
%endif
	--disable-static
%make_build

%install
%makeinstall_std

# Remove standard libdir from exacutables and library RPATH
chrpath -d %buildroot%_bindir/* %buildroot%_libdir/libodbccr.so*

install -pD -m644 %SOURCE1 %buildroot%_sysconfdir/odbcinst.ini
subst "s,@libdir@,%_libdir," %buildroot%_sysconfdir/odbcinst.ini

find doc -name Makefile\* -delete

%files
%doc AUTHORS COPYING README doc/AdministratorManual doc/UserManual doc/index.html doc/*.gif
%config(noreplace) %verify(not md5 size mtime) %_sysconfdir/odbc*.ini
%_bindir/dltest
%_bindir/isql
%_bindir/iusql
%_bindir/odbcinst
%_bindir/slencheck
%doc %_man1dir/*
%doc %_man5dir/*
%doc %_man7dir/*

%files -n lib%name%abiversion
%_libdir/lib*.so.*
%_libdir/libodbcpsql.so
%_libdir/libodbcpsqlS.so
%_libdir/libodbcmyS.so

%files -n lib%name-devel-compat
%_libdir/libodbc.so
%_libdir/libodbcinst.so

%files -n lib%name-devel
%doc ChangeLog doc/ProgrammerManual doc/lst
%_includedir/*
%_bindir/odbc_config
%_libdir/lib*.so
%exclude %_libdir/libodbc.so
%exclude %_libdir/libodbcinst.so
%exclude %_libdir/libodbcpsql.so
%exclude %_libdir/libodbcpsqlS.so
%exclude %_libdir/libodbcmyS.so
%_pkgconfigdir/*.pc

%changelog
