Name: vice
Version: 3.4
Release: alt2

Summary: Versatile Commodore Emulator
Summary(pl.UTF-8): Uniwersalny emulator Commodore
License: GPL-2.0-or-later
Group: Emulators

Url: https://netcologne.dl.sourceforge.net/project/vice-emu
Source0: https://netcologne.dl.sourceforge.net/project/vice-emu/releases/%name-%version.tar.gz
Source1: vice-c128.desktop
Source2: vice-c1541.desktop
Source3: vice-c64dtv.desktop
Source4: vice-c64sc.desktop
Source5: vice-cbm2.desktop
Source6: vice-cbm5x0.desktop
Source7: vice-pet.desktop
Source8: vice-plus4.desktop
Source9: vice-vic20.desktop
Source10: vice-vsid.desktop
Source11: vice-normalicons.tar.bz2
Source12: vice-largeicons.tar.bz2
Source13: vice-miniicons.tar.bz2
Patch0: vice-3.4-fix-build.patch
Patch1: vice-3.4-fix-destination-path.patch
Packager: Michael Shigorin <mike@altlinux.org>

BuildRequires: flex gcc-c++
BuildRequires: libGL-devel
BuildRequires: libSDL2-devel
BuildRequires: libXrandr-devel
BuildRequires: libesd-devel
BuildRequires: libjpeg-devel
BuildRequires: liblame-devel
BuildRequires: libreadline-devel
BuildRequires: libungif-devel
BuildRequires: libpng-devel
BuildRequires: zlib-devel
BuildRequires: libX11-devel
BuildRequires: libXxf86vm-devel
BuildRequires: libalsa-devel
BuildRequires: makeinfo
BuildRequires: xa
BuildRequires: libpulseaudio-devel
BuildRequires: libavcodec-devel libswresample-devel

%description
VICE is a Versatile Commodore Emulator, i.e. a program that runs on a
Unix, MS-DOS, Win95/NT, OS/2, RiscOS or BeOS machine and executes
programs intended for the old 8-bit Commodore computers. The current
version emulates the C64, the C128 (80 column screen is included now),
the VIC20, all the PET models (except the SuperPET 9000, which is out
of line anyway), CBM-II (aka C610) and the Plus4.

%description -l pl.UTF-8
VICE jest wszechstronnym emulatorem 8-bitowego komputera Commodore.
Aktualna wersja emuluje C64, C128 (wraz z trybem pracy 80 kolumnowym),
VIC20, wszystkie modele PET (poza SuperPET 9000, który zresztą nie
pasował do tej linii), CBM-II (C610) oraz Plus4.

%prep
%setup
%patch0 -p2
%patch1 -p2

%build
touch ABOUT-NLS config.rpath
%add_optflags -fno-strict-aliasing
%autoreconf
%configure \
	--enable-sdlui2 \
	--enable-external-ffmpeg

%make_build

%install
install -d %buildroot{%_desktopdir,%_pixmapsdir}

perl -i -pe 's/SUBDIRS = html\n//' doc/Makefile
%make_install install DESTDIR=%buildroot 

rm -f doc/html/{Makefile*,texi2html}
rm -rf %buildroot%_datadir/vice/doc

install -pm644 \
	%SOURCE1 %SOURCE2 %SOURCE3 %SOURCE4 %SOURCE5 \
	%SOURCE6 %SOURCE7 %SOURCE8 %SOURCE9 %SOURCE10 \
	%buildroot%_desktopdir

mkdir -p %buildroot%_iconsdir/hicolor/{16x16,32x32,48x48}/apps
tar xjf %SOURCE11 -C %buildroot%_iconsdir/hicolor/32x32/apps
tar xjf %SOURCE12 -C %buildroot%_iconsdir/hicolor/48x48/apps
tar xjf %SOURCE13 -C %buildroot%_iconsdir/hicolor/16x16/apps

%find_lang %name

%files -f %name.lang
%doc AUTHORS ChangeLog FEEDBACK NEWS README
%doc doc/iec-bus.txt doc/html
%_bindir/*
%_prefix/lib/%name/
%_mandir/man?/*
%_infodir/*.info*
%_desktopdir/*.desktop
#_pixmapsdir/*
%_iconsdir/hicolor/*/*/*.png

%changelog
