%def_enable snapshot

%define ver_major 3.22
%define api_ver 3.0
%define _libexecdir %_prefix/libexec

# freerdp >= 2.0.0-alt0.git20160331 required
%def_enable rdp
%def_enable spice
%def_enable telepathy
%def_enable ssh

Name: vinagre
Version: %ver_major.0
Release: alt4

Summary: Remote desktop viewer for the GNOME Desktop
License: GPLv2
Group: Networking/Remote access
URL: https://wiki.gnome.org/Apps/Vinagre

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Requires: dconf gnome-icon-theme-symbolic
%{?_enable_rdp:Requires: freerdp >= 2.0.0-alt0.git20160331}

BuildPreReq: rpm-build-gnome gnome-common desktop-file-utils
BuildPreReq: libappstream-glib-devel
BuildPreReq: intltool >= 0.35 glib2-devel >= 2.28.0
BuildPreReq: libgtk+3-devel >= 3.9.6 libgtk3vnc-devel >= 0.4.3-alt2
BuildRequires: libavahi-gobject-devel libavahi-ui-gtk3-devel libsecret-devel
BuildRequires: yelp-tools itstool xmllint
%{?_enable_ssh:BuildRequires: libvte3-devel >= 0.37 libxml2-devel}
%{?_enable_telepathy:BuildRequires: libtelepathy-glib-devel >= 0.11.6 libdbus-glib-devel}
%{?_enable_spice:BuildRequires: libspice-gtk3-devel}
%{?_enable_rdp:BuildRequires: libfreerdp-devel >= 1.1}
BuildRequires: gcc-c++

%description
Vinagre is a remote desktop viewer for GNOME, that uses Virtual Network
Computing (VNC) to remotely control another desktop. Additional
protocols, such as RDP and SSH, are also supported.

%prep
%setup
[ ! -d m4 ] && mkdir m4

%build
%autoreconf
# for SSH plugin
export LIBS="$LIBS `pkg-config --libs libxml-2.0`"
%configure \
	--enable-ssh \
	%{subst_enable spice} \
	%{subst_enable ssh} \
	%{subst_enable rdp} \
	%{?_disable_introspection:--enable-introspection=no} \
	--disable-schemas-compile
%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name

rm -rf %buildroot%_datadir/doc

%files -f %name.lang
%_bindir/%name
%_datadir/%name/
%_datadir/telepathy/clients/Vinagre.client
%_datadir/applications/*.desktop
%_datadir/icons/hicolor/*/*/*
%_datadir/mime/packages/vinagre-mime.xml
%_datadir/dbus-1/services/org.freedesktop.Telepathy.Client.Vinagre.service
%config %_datadir/glib-2.0/schemas/org.gnome.Vinagre.gschema.xml
%_datadir/GConf/gsettings/org.gnome.Vinagre.convert
%_datadir/metainfo/%name.appdata.xml
%_man1dir/vinagre.*
%doc AUTHORS NEWS README

%changelog
