%def_disable snapshot
%def_disable doc
# since mesa-18.0 wayland-egl moved to this wayland package
%define main_ver 1.18.0
%define egl_ver 18.1.0
%define mesa_epoch 4

Name: wayland
Version: %main_ver
Release: alt1

Summary: Wayland protocol libraries
Group: System/X11
License: MIT
Url: http://%name.freedesktop.org/

%if_disabled snapshot
Source: http://%name.freedesktop.org/releases/%name-%version.tar.xz
%else
# git://anongit.freedesktop.org/wayland/wayland
Source: %name-%version.tar
%endif

BuildRequires: /proc doxygen libexpat-devel libffi-devel libxml2-devel xsltproc docbook-style-xsl
%{?_enable_doc:BuildRequires: /proc graphviz xmlto}

%description
Wayland is a project to define a protocol for a compositor to talk to
its clients as well as a library implementation of the protocol. The
compositor can be a standalone display server running on Linux kernel
modesetting and evdev input devices, an X applications, or a wayland
client itself. The clients can be traditional applications, X servers
(rootless or fullscreen) or other display servers.

See https://wayland.freedesktop.org/releases.html for release news.

%package devel
Summary: Common headers for Wayland
Group: Development/C

%description devel
Common headers for Wayland.

%package -n lib%name-client
Summary: Wayland client library
Group: System/Libraries

%description -n lib%name-client
Wayland client shared library.

%package -n lib%name-client-devel
Summary: Development files for Wayland client library
Group: Development/C
Requires: lib%name-client = %EVR
Requires: %name-devel = %EVR

%description -n lib%name-client-devel
This package provides development files for Wayland client library.

%package -n lib%name-server
Summary: Wayland server library
Group: System/Libraries

%description -n lib%name-server
Wayland server shared library.

%package -n lib%name-server-devel
Summary: Development files for Wayland server library
Group: Development/C
Requires: lib%name-server = %EVR
Requires: %name-devel = %EVR

%description -n lib%name-server-devel
This package provides development files for Wayland server library.

%package -n lib%name-cursor
Summary: Wayland cursor helper library
Group: System/Libraries
Requires: lib%name-client = %EVR

%description -n lib%name-cursor
Wayland cursor helper shared library.

%package -n lib%name-cursor-devel
Summary: Wayland cursor helper library
Group: Development/C
Requires: lib%name-cursor = %EVR
Requires: lib%name-client-devel = %EVR

%description -n lib%name-cursor-devel
This package provides development files for Wayland cursor helper library.

%package -n lib%name-egl
Version: %egl_ver
Epoch: %mesa_epoch
Summary: Wayland-EGL library
Group: System/Libraries
Requires: lib%name-client = %main_ver-%release

%description -n lib%name-egl
EGL library for Wayland

%package -n lib%name-egl-devel
Version: %egl_ver
Epoch: %mesa_epoch
Summary: Wayland-EGL development package
Group: Development/C
Requires: lib%name-egl = %epoch:%egl_ver-%release
Requires: lib%name-client-devel = %main_ver-%release

%description -n libwayland-egl-devel
Wayland-EGL development package

%prep
%setup

%build
%add_optflags -D_FILE_OFFSET_BITS=64
%autoreconf
%configure --disable-static \
	%{?_disable_doc:--disable-documentation}
%make_build

%install
%makeinstall_std

%check
%make check

%files devel
#%doc %_docdir/%name-devel
%_bindir/%name-scanner
%_includedir/%name-util.h
%_includedir/%name-version.h
%_datadir/aclocal/%name-scanner.*
%_libdir/pkgconfig/%name-scanner.pc
%dir %_datadir/%name
%_datadir/%name/%name-scanner.mk
%_datadir/%name/%name.xml
%_datadir/%name/wayland.dtd
# too many broken links
%{?_enable_doc:%_man3dir/*}

%files -n lib%name-client
%_libdir/lib%name-client.so.*
%doc README COPYING

%files -n lib%name-client-devel
%_includedir/%name-client*.h
%_includedir/%name-egl-core.h
%_includedir/wayland-egl.h
%_libdir/lib%name-client.so
%_pkgconfigdir/%name-client.pc

%files -n lib%name-server
%_libdir/lib%name-server.so.*

%files -n lib%name-server-devel
%_includedir/%name-server*.h
%_libdir/lib%name-server.so
%_pkgconfigdir/%name-server.pc

%files -n lib%name-cursor
%_libdir/lib%name-cursor.so.*

%files -n lib%name-cursor-devel
%_includedir/%name-cursor.h
%_libdir/lib%name-cursor.so
%_pkgconfigdir/%name-cursor.pc

%files -n lib%name-egl
%_libdir/lib%name-egl.so.*

%files -n lib%name-egl-devel
%_includedir/wayland-egl-backend.h
%_libdir/lib%name-egl.so
%_pkgconfigdir/%name-egl.pc
%_pkgconfigdir/%name-egl-backend.pc


%changelog
