%define majver 2.23
%define minver 08
%define suff RB30

Name: webalizer
Version: %majver.%minver.%suff
Release: alt1

Summary: Web/ftp/proxy server log analyser
License: GPL
Group: Monitoring

Url: http://www.patrickfrei.ch/webalizer/%name
Source0: %name-%majver-%minver-%suff-src.tar
Source1: %name.conf
Source2: README.ALT-webalizer

%define apache_group apache
%define apache_log %_logdir/httpd/access_log
%define vsftpd_log %_logdir/vsftpd.log
%define dns_cache  %_localstatedir/%name/dns_cache.db
%define webalizer_user webalizer
%define webalizer_group webalizer
%define webalizer_home %_localstatedir/%name
%define webalizer_html %_var/www/html/%name
%define geoip_data %_datadir/GeoIP/GeoIP.dat

Summary(ru_RU.UTF-8): Анализатор логов web/ftp/proxy-серверов

# Automatically added by buildreq on Sat Aug 16 2008
BuildRequires: rpm-macros-apache rpm-macros-apache2 bzlib-devel libGeoIP-devel libdb4-devel libgd2-devel libpng-devel

BuildRequires: zlib-devel bzlib-devel

Requires: db4-utils

%description
The Webalizer is a web server log file analysis program which produces
usage statistics in HTML format for viewing with a browser.  The results
are presented in both columnar and graphical format, which facilitates
interpretation.  Yearly, monthly, daily and hourly usage statistics are
presented, along with the ability to display usage by site, URL, referer,
user agent (browser) and country (user agent and referrer are only
available if your web server produces combined log format files).
Webalizer Xtended is especially useful for all those users who would like
to have detailed HTML-404-statistics (i.e. about broken links and visitors
trying to look-up folders and files containing potentionally vulnerable
software). As further features, all colors of the statistics can be
defined by the user and the country resp. traffic statistics are more
reliable due to the implementation of Geolizer resp.


%description -l ru_RU.UTF-8
The Webalizer -- программа для анализа лог-файлов web-сервера Apache и
некоторых других, представляющая результаты в виде HTML (таблицы и диаграммы).
Собирается годичная, помесячная, ежедневная и почасовая статистика с
возможностью просмотра по сайтам, URL, реферрерам, браузерам, странам.

В этой версии также собирается детальная статистика ошибок 404 (неправильные
линки) Webalizer Xtended полезен тем, кому необходима детальная статистика по
404-ошибкам (неправильные ссылки, попытки пользователей просмотреть каталоги
и файлы, содержащие потенциально опасные приложения). Дополнительно есть
возможность определить цветовые гаммы статистики и включена поддержка Geolizer.

%prep
%setup -n %name-%majver-%minver-%suff

%build
CFLAGS="%optflags -fsigned-char"
%configure \
	--with-db \
	--with-dblib \
	--enable-dns \
	--enable-geoip \
	--with-bzlib \
	--with-bz-inc

# patch the template; keep common data in HOME, distinct in DATA
sed -e "s,__HTML__,%webalizer_html,g" \
    -e "s,__HOME__,%webalizer_home,g" \
    -e "s,__DATA__,%webalizer_home,g" \
    -e "s,__LOGFILE__,%apache_log,g" \
    -e "s,__GEOIPDATA__,%geoip_data,g" \
    -e "s,__LOGTYPE__,clf,g" \
< %SOURCE1 \
> apache.conf

sed -e "s,__HTML__,%webalizer_html/ftp,g" \
    -e "s,__HOME__,%webalizer_home,g" \
    -e "s,__DATA__,%webalizer_home/ftp,g" \
    -e "s,__LOGFILE__,%vsftpd_log,g" \
    -e "s,__GEOIPDATA__,%geoip_data,g" \
    -e "s,__LOGTYPE__,ftp	# xferlog_std_format=YES to /etc/vsftpd.conf,g" \
< %SOURCE1 \
> vsftpd.conf

%make_build

%install
install -d %buildroot%_sysconfdir/{,%name,cron.d}
install -d %buildroot%_bindir
install -d %buildroot%_docdir
install -d %buildroot%webalizer_home
install -d %buildroot%webalizer_html
install -d %buildroot%_mandir/man1
install -m644 sample.conf %buildroot%_docdir/
install -m644 apache.conf %buildroot%_sysconfdir/%name/
install -m644 vsftpd.conf %buildroot%_sysconfdir/%name/
install -m755 webalizer %buildroot%_bindir
install -m644 webalizer.1 %buildroot%_man1dir
install -m644 webalizer.png %buildroot%webalizer_html
install -m644 msfree.png %buildroot%webalizer_html
touch %buildroot%_sysconfdir/%name.conf

cat << EOF > %buildroot%_sysconfdir/cron.d/%name
#!/bin/sh
15 03 * * * %webalizer_user %_bindir/%name -c %_sysconfdir/%name/apache.conf
#25 03 * * * %webalizer_user %_bindir/%name -c %_sysconfdir/%name/vsftpd.conf
EOF

ln -s webalizer %buildroot/%_bindir/webasolve

install -m644 %SOURCE2 README.ALT

%pre
grep -q "^%webalizer_group:" %_sysconfdir/group \
|| %_sbindir/groupadd -r -f %webalizer_group ||:
grep -q "^%webalizer_user:" %_sysconfdir/passwd \
|| %_sbindir/useradd -g %webalizer_group -G %apache_group -c 'The Webalizer' \
	-d %webalizer_home -s /dev/null -r %webalizer_user ||: 
if LANG=C %_bindir/id -Gn %apache2_user >/dev/null 2>&1;then \
	 %_sbindir/usermod -G %apache_group,%apache2_group %webalizer_user ||:
fi

%post
# get hostname.  This way till we have a macro.
W_HOST=`hostname`
[ $? = 0 ] || W_HOST=localhost
[ $? = 0 ] && {
	sed -i "s,__HOST__,$W_HOST,g" %_sysconfdir/%name/apache.conf ||:
}
[ $? = 0 ] && {
	sed -i "s,__HOST__,$W_HOST,g" %_sysconfdir/%name/vsftpd.conf ||:
}
[ -f "%_sysconfdir/%name.conf" ] && \
echo "NB: default webalizer configuration place is under %_sysconfdir/%name/ now
to allow for easier management of .conf files; you may want to look there
and/or update your setup." ||:

# we don't need no db_upgrade
rm -f %dns_cache ||:

#postun
#_sbindir/userdel webalizer <-- don't do it!

# fix awful user/group deletion in previous spec versions :(
%triggerpostun -- webalizer < 2.01.10-alt3
echo "Fixing permissions after faulty previous package:"
%_sbindir/groupadd -r -f %webalizer_group ||:
%_sbindir/useradd -g %webalizer_group -G %apache_group -c 'The Webalizer' \
	-d %webalizer_home -s /dev/null -r %webalizer_user ||: 
for i in %webalizer_home %webalizer_html; do
	find $i -group %apache_webmaster \( -type f -o -type d \) -print0 \
	| xargs -r0 -- chown -Rv root:%webalizer_group
done

%files
%doc CHANGES DNS.README INSTALL README* country-codes.txt sample.conf
%config(noreplace) %_sysconfdir/cron.d/*
%config(noreplace) %verify(not size mtime md5) %_sysconfdir/%name/*
%ghost %config(noreplace,missingok) %verify(not size mtime md5) %_sysconfdir/%name.conf
%_bindir/*
%_man1dir/*
%dir %attr(775,root,%webalizer_group) %webalizer_home
%dir %attr(775,root,%webalizer_group) %webalizer_html
%attr(644,root,%webalizer_group) %webalizer_html/*

# FIXME:
# - wait for pseudouser naming/mgmt policy and fix the package (finally)
# - bak-around userdel -r in early packages?

%changelog
