%def_disable static

Name: xapian-core
Version: 1.4.15
Release: alt1

Summary: The Xapian Probabilistic Information Retrieval Library

License: GPL
Group: Databases
Url: http://www.xapian.org

Source: http://www.oligarchy.co.uk/xapian/%version/%{name}-%{version}.tar
Source100: %name.watch

Packager: Michael Shigorin <mike@altlinux.org>

BuildRequires: gcc-c++ zlib-devel libuuid-devel

%description
Xapian is an Open Source Probabilistic Information Retrieval Library.
It offers a highly adaptable toolkit that allows developers to easily
add advanced indexing and search facilities to applications.

This is core package.

%package -n libxapian
Summary: Xapian search engine libraries
Group: System/Libraries

%description -n libxapian
Xapian is an Open Source Probabilistic Information Retrieval Library.
It offers a highly adaptable toolkit that allows developers to easily
add advanced indexing and search facilities to applications.

This package provides the libraries for applications using Xapian
functionality.

%package -n libxapian-devel
Group: Development/C++
Summary: Files needed for building packages which use Xapian
Requires: libxapian = %version

%description -n libxapian-devel
This package provides the files needed for building packages which
use Xapian library.

%if_enabled static
%package -n libxapian-devel-static
Group: Development/C++
Summary: Files needed for building packages which use Xapian statically
Requires: libxapian-devel = %version

%description -n libxapian-devel-static
This package provides the files needed for building packages which
link against Xapian library statically or use XO_LIB_XAPIAN macroo
and build with libtool.
%endif

%package -n %name-doc
Group: Development/Documentation
Summary: Developer's documentation for Xapian
Obsoletes: xapian-doc < 0.9.9
Provides: xapian-doc = %version-%release
BuildArch: noarch

%description -n %name-doc
Xapian is an Open Source Probabilistic Information Retrieval Library.
It offers a highly adaptable toolkit that allows developers to easily
add advanced indexing and search facilities to applications.

This package contains API reference in HTML and PostScript.

%prep
%setup
%ifarch %e2k
# current lcc doesn't know these
sed -i  -e 's,-fno-gnu-keywords,,;s,-Wstrict-null-sentinel,,' \
	-e 's,-Wstrict-overflow=1,,;s,-Wlogical-op,,;s,-Wdouble-promotion,,' \
	configure.ac
# http://stackoverflow.com/questions/14892101/
%add_optflags -ftls-model=global-dynamic
%endif

%build
%autoreconf
%configure %{subst_enable static}
%make_build
gzip -9nf ChangeLog

%install
%makeinstall_std
rm -rf %buildroot%_datadir/doc/xapian-core/

%if_enabled static
# should we still support this?
%else
rm -f %buildroot%_libdir/libxapian.a
%endif

%files
%_bindir/copydatabase
%_bindir/quest
%_bindir/simpleexpand
%_bindir/simpleindex
%_bindir/simplesearch
%_bindir/xapian-check
%_bindir/xapian-compact
%_bindir/xapian-delve
%_bindir/xapian-metadata
%_bindir/xapian-progsrv
%_bindir/xapian-replicate
%_bindir/xapian-replicate-server
%_bindir/xapian-tcpsrv
%_datadir/xapian-core/
%_man1dir/*.1*
%doc AUTHORS ChangeLog* NEWS PLATFORMS README

%files -n libxapian
%_libdir/*.so.*

%files -n libxapian-devel
%_bindir/xapian-config
%_includedir/xapian.h
%_includedir/xapian/
%_libdir/libxapian.so
%_libdir/cmake/xapian/
%_datadir/aclocal/xapian.m4
%_pkgconfigdir/*.pc

%if_enabled static
%files -n libxapian-devel-static
%_libdir/libxapian.a
%endif

%files -n %name-doc
%doc docs/*.html
%doc docs/apidoc/html/
%doc HACKING

# NOTE:
# - do NOT build this package from git unless you want to maintain it,
#   I use watch file and it's more convenient to do that with srpms

%changelog
