# vim: set ft=spec: -*- rpm-spec -*-

Name: xca
Version: 2.1.1
Release: alt1

Summary: A GUI for handling X509 certificates, RSA keys, PKCS#10 Requests
Group: Security/Networking
License: BSD
Url: https://hohnstaedt.de/xca/
# sources: https://github.com/chris2511/xca/

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: qt5-base-devel qt5-tools
BuildRequires: libltdl-devel openssl-devel linuxdoc-tools rpm-build-xdg OpenSP groff-base

%description
Graphical certification authority is an interface for managing RSA
keys and certificates, and the creation and signing of PKCS#10
requests. It uses the OpenSSL library and a Berkeley DB for key and
certificate storage. It supports importing and exporting keys and PEM
DER PKCS8 certificates, signing and revoking of PEM DER PKCS12, and
the selection of x509v3 extensions. A tree view of certificates is
presented.

%prep
%setup
%patch -p1

%build
./bootstrap
CFLAGS="%optflags" \
CXXFLAGS="%optflags" \
./configure --prefix="%_prefix" \
      docdir=%_docdir/%name-%version
%make_build

%install
mkdir -p %buildroot{%_bindir,%_datadir/xca,%_desktopdir,%_man1dir}

%make_install install \
    destdir=%buildroot prefix=/usr STRIP=: \
    mandir=%_mandir docdir=%_docdir/%name-%version datarootdir=%_datadir

%files
%doc AUTHORS doc/*.html
%_bindir/*
%_datadir/xca
%_desktopdir/xca*
%_man1dir/xca*.1*
%_xdgmimedir/packages/xca.xml
%_pixmapsdir/xca*.xpm

%changelog
