%def_with efi
%def_enable xsmpolicy
%def_enable vtpm
%def_enable ocamltools
%def_enable monitors
%def_enable xenapi

%ifndef x86_64
%define x86_64 x86_64
%endif

Summary: Xen is a virtual machine monitor (hypervisor)
Name: xen
Version: 4.10.3
Release: alt1
Group: Emulators
License: GPLv2+, LGPLv2+, BSD
URL: http://www.xenproject.org/

%define pre %nil
%define qemu_ver %version%pre

Source0: %name-%version%pre.tar
Source1: qemu-xen-%qemu_ver.tar
Source2: qemu-xen-traditional-%qemu_ver.tar
Source3: mini-os-%version%pre.tar
Source4: %name.logrotate
Source5: %name-qemu-dom0

# used by stubdoms
Source10: newlib-1.16.0.tar.gz
Source11: zlib-1.2.3.tar.gz
Source12: polarssl-1.1.4-gpl.tgz
Source13: lwip-1.3.0.tar.gz
Source14: grub-0.97.tar.gz
Source15: pciutils-2.2.9.tar.bz2
%if_enabled vtpm
Source16: tpm_emulator-0.7.4.tar.gz
Source17: gmp-4.3.2.tar.bz2
%endif

# systemd bits
Source49: tmpfiles.d.xen.conf

Patch0: %name-%version-upstream.patch
Patch1: %name-%version-alt.patch

# Fedora
Patch5: %name-net-disable-iptables-on-bridge.patch

Patch10: pygrubfix.patch
Patch15: %name.use.fedora.ipxe.patch
Patch17: %name.fedora.efi.build.patch
Patch19: %name.pygrubtitlefix.patch

# ALT
Patch50: %name-4.0.0-libfsimage-soname-alt.patch
Patch55: qemu-traditional-lost-parenthesis.patch
Patch56: qemu-xen-non-static-memfd_create.patch


ExclusiveArch: %ix86 %x86_64

Requires: bridge-utils
Requires: python-module-lxml
Requires: udev >= 059
Requires: chkconfig

%ifarch %ix86
%def_without hypervisor
%else
%def_with hypervisor
%endif

# xen only supports efi boot images on x86_64
%ifnarch %x86_64
%def_without efi
%endif

# no point in trying to build xsm on ix86 without a hypervisor
%if_without hypervisor
%def_disable xsmpolicy
%endif

%ifarch %ix86 %x86_64
%def_enable stubdom
%else
%def_disable stubdom
%endif

BuildRequires(pre): rpm-macros-uefi

BuildRequires: glibc-devel zlib-devel libncurses-devel libaio-devel
BuildRequires: python-devel ghostscript %_bindir/texi2html transfig
BuildRequires: pkgconfig(glib-2.0) >= 2.12
# for the docs
BuildRequires: perl(Pod/Man.pm) perl(Pod/Text.pm) texinfo graphviz
BuildRequires: discount perl-devel
# so that the makefile knows to install udev rules
BuildRequires: udev
BuildRequires: gettext libgnutls-devel libssl-devel
# For ioemu PCI passthrough
BuildRequires: libpci-devel
# Several tools now use uuid
BuildRequires: libuuid-devel
# iasl needed to build hvmloader
BuildRequires: iasl
# build using Fedora seabios and ipxe packages for roms
BuildRequires: seabios ipxe-roms-qemu
# modern compressed kernels
BuildRequires: bzlib-devel liblzma-devel
# libfsimage
BuildRequires: libe2fs-devel
# tools now require yajl
BuildRequires: libyajl-devel
%{?_enable_ocamltools:BuildRequires: ocaml ocaml-ocamlbuild ocaml-ocamldoc ocaml-findlib}
%{?_enable_xenapi:BuildRequires: libxml2-devel}

%ifarch %ix86 %x86_64
# for the VMX "bios"
BuildRequires: dev86
# efi image needs an ld that has -mi386pep option
%{?_with_efi:BuildRequires: mingw64-binutils >= 2.26}
%endif

BuildRequires: libSDL-devel libXext-devel
# xsm policy file needs needs checkpolicy and m4
%{?_enable_xsmpolicy:BuildRequires: checkpolicy m4}
%{?_enable_stubdom:BuildRequires: makeinfo}
# with hypervisor
BuildRequires: flex discount libfdt-devel libgcrypt-devel liblzo2-devel perl-HTML-Parser perl-devel
# from 4.7.0
BuildRequires: libnl-devel >= 3.2.8 libnl3 >= 3.2.8 libnl3-utils >= 3.2.8
BuildRequires: libpixman-devel >= 0.21.8 libpixman >= 0.21.8
BuildRequires: libnettle-devel nettle
BuildRequires: gcc-c++
BuildRequires: libsystemd-devel >= 209
# VirtFS support
BuildRequires: libcap-devel libattr-devel
# Qemu-Xen VNC-PNGm VNC-JPEG support
BuildRequires: libpng-devel libjpeg-devel
%{?_enable_vtpm:BuildRequires: cmake}

%description
The Xen Project hypervisor is an open-source type-1 or baremetal
hypervisor, which makes it possible to run many instances of an
operating system or indeed different operating systems in parallel on a
single machine (or host). The Xen Project hypervisor is the only type-1
hypervisor that is available as open source. It is used as the basis for
a number of different commercial and open source applications, such as:
server virtualization, Infrastructure as a Service (IaaS),
desktop virtualization, security applications, embedded and hardware
appliances. The Xen Project hypervisor is powering the largest clouds in
production today.

This package contains the command line tools, needed to manage virtual
machines running under the Xen hypervisor.

%filter_from_requires /^\s*\(open-iscsi\|nbd-client\|drbd-utils\)\s*$/d


%package -n lib%name
Summary: Shared libraries for Xen tools
Group: System/Libraries
Provides: %name-libs = %version-%release
Obsoletes: %name-libs
Requires: xen-licenses

%description -n lib%name
The Xen Project hypervisor is an open-source type-1 or baremetal
hypervisor, which makes it possible to run many instances of an
operating system or indeed different operating systems in parallel on a
single machine (or host).

This package contains the libraries needed to run applications
which manage Xen virtual machines.


%package -n lib%name-devel
Summary: Development libraries for Xen tools
Group: Development/C
Provides: %name-devel = %version-%release
Obsoletes: %name-devel
Requires: lib%name = %version-%release
Requires: libuuid-devel

%description -n lib%name-devel
The Xen Project hypervisor is an open-source type-1 or baremetal
hypervisor, which makes it possible to run many instances of an
operating system or indeed different operating systems in parallel on a
single machine (or host).

This package contains what's needed to develop applications
which manage Xen virtual machines.


%package runtime
Summary: Core Xen runtime environment
Group: Emulators
Requires: %name = %version-%release
Requires: lib%name = %version-%release
Requires: seabios ipxe-roms-qemu

%description runtime
The Xen Project hypervisor is an open-source type-1 or baremetal
hypervisor, which makes it possible to run many instances of an
operating system or indeed different operating systems in parallel on a
single machine (or host).

This package contains the runtime programs which form the core Xen
userspace environment.


%if_with hypervisor
%package hypervisor
Summary: Xen hypervisor
Group: System/Kernel and hardware
Requires: xen-licenses

%description hypervisor
The Xen Project hypervisor is an open-source type-1 or baremetal
hypervisor, which makes it possible to run many instances of an
operating system or indeed different operating systems in parallel on a
single machine (or host).

This package contains the Xen hypervisor.
%endif


%package doc
Summary: Xen documentation
Group: Documentation
Requires: xen-licenses

%description doc
The Xen Project hypervisor is an open-source type-1 or baremetal
hypervisor, which makes it possible to run many instances of an
operating system or indeed different operating systems in parallel on a
single machine (or host). The Xen Project hypervisor is the only type-1
hypervisor that is available as open source. It is used as the basis for
a number of different commercial and open source applications, such as:
server virtualization, Infrastructure as a Service (IaaS),
desktop virtualization, security applications, embedded and hardware
appliances. The Xen Project hypervisor is powering the largest clouds in
production today.

This package contains the Xen documentation.


%package licenses
Summary: License files from Xen source
Group: Documentation

%description licenses
The Xen Project hypervisor is an open-source type-1 or baremetal
hypervisor, which makes it possible to run many instances of an
operating system or indeed different operating systems in parallel on a
single machine (or host).

This package contains the license files from the source used
to build the xen packages.


%if_enabled ocamltools
%package ocaml
Summary: Ocaml libraries for Xen tools
Group: Emulators
Requires: ocaml-runtime, lib%name = %version-%release

%description ocaml
The Xen Project hypervisor is an open-source type-1 or baremetal
hypervisor, which makes it possible to run many instances of an
operating system or indeed different operating systems in parallel on a
single machine (or host).

This package contains libraries for ocaml tools to manage Xen
virtual machines.


%package ocaml-devel
Summary: Ocaml development libraries for Xen tools
Group: Development/Other
Requires: %name-ocaml = %version-%release

%description ocaml-devel
The Xen Project hypervisor is an open-source type-1 or baremetal
hypervisor, which makes it possible to run many instances of an
operating system or indeed different operating systems in parallel on a
single machine (or host).

This package contains libraries for developing ocaml tools to
manage Xen virtual machines.
%endif


%ifarch %ix86 %x86_64
%package stubdoms
Summary: Xen Hypervisor Stub Domains
Group: Emulators

%description stubdoms
The Xen Project hypervisor is an open-source type-1 or baremetal
hypervisor, which makes it possible to run many instances of an
operating system or indeed different operating systems in parallel on a
single machine (or host).

Stubdoms (or stub domains) are lightweight 'service' or 'driver' domain
to run device models and one technique to implement Dom0 Disaggregation.
The initial purpose of stub domains were to offload qemu workloads from
dom0 into a seperate domain.

So with stub domains, a separate unprivileged stub domain is created per
HVM guest. This boosts performance and makes your system more secure.
%endif


%prep
%setup -q -n %name-%version%pre -a1 -a2 -a3

mkdir extras
ln -s ../qemu-xen-%version tools/qemu-xen
ln -s ../qemu-xen-traditional-%version tools/qemu-xen-traditional
ln -s ../mini-os-%version extras/mini-os

%patch0 -p1
%patch1 -p1
%patch5 -p1
%patch10 -p1
%patch15 -p1
%patch17 -p1
%patch19 -p1
%patch50 -p2

pushd tools/qemu-xen-traditional
%patch55 -p1
popd

pushd tools/qemu-xen
%patch56 -p1
popd

sed -i '/^[[:blank:]]*\. \/etc\/rc\.status[[:blank:]]*$/s/\. /: # &/' tools/hotplug/Linux/xendomains.in

# stubdoms sources
pushd stubdom
ln -s %SOURCE10
ln -s %SOURCE11
ln -s %SOURCE12
ln -s %SOURCE13
ln -s %SOURCE14
ln -s %SOURCE15

%if_enabled vtpm
ln -s %SOURCE16
ln -s %SOURCE17
%endif
popd

%build
%{?_with_efi:install -d -m 0755 dist/install/boot/efi/efi/altlinux}
#export QEMU_REMOTE=$PWD/qemu-%name-%qemu_ver
#export CONFIG_QEMU=$PWD/qemu-%name-%qemu_ver
#export QEMU_UPSTREAM_URL=$PWD/qemu-upstream-%version%pre
#	--with-system-qemu \
#	--enable-qemu \
%if "%pre" == "%nil"
export XEN_VENDORVERSION="-%release"
%else
v="%version"
export XEN_EXTRAVERSION="${v#${v%%.*}}-%release"
%endif
export EXTRA_CFLAGS_XEN_TOOLS="%optflags"
export EXTRA_CFLAGS_QEMU_TRADITIONAL="%optflags"
export EXTRA_CFLAGS_QEMU_XEN="%optflags"
%{?_enable_xenapi:export XML=$(which xml2-config)}
export WGET=$(which true)
export GIT=$(which true)
./configure \
	--prefix=%_prefix \
	--libdir=%_libdir \
	--enable-xen \
	--with-system-seabios=%_datadir/seabios/bios-256k.bin \
	--with-systemd=%_unitdir \
	--with-xenstored=xenstored \
	--without-systemd-modules-load \
	%{subst_enable xsmpolicy} \
	%{subst_enable xenapi} \
	%{subst_enable monitors} \
	%{subst_enable stubdom} \
%if_enabled vtpm
	--enable-vtpm-stubdom \
	--enable-vtpmmgr-stubdom \
%else
	--disable-vtpm-stubdom \
	--disable-vtpmmgr-stubdom \
%endif
	%{subst_enable ocamltools} \
	--enable-tools \
	--enable-kvm \
	--disable-kernels \
	--enable-docs
%make_build %{?_with_efi:LD_EFI=x86_64-pc-mingw32-ld}


%install
#export QEMU_REMOTE=$PWD/qemu-%name-%qemu_ver
#export CONFIG_QEMU=$PWD/qemu-%name-%qemu_ver
#export QEMU_UPSTREAM_URL=$PWD/qemu-upstream-%version%pre
%if "%pre" == "%nil"
export XEN_VENDORVERSION="-%release"
%else
v="%version"
export XEN_EXTRAVERSION="${v#${v%%.*}}-%release"
%endif
export EXTRA_CFLAGS_XEN_TOOLS="%optflags"
export EXTRA_CFLAGS_QEMU_TRADITIONAL="%optflags"
export EXTRA_CFLAGS_QEMU_XEN="%optflags"
%{?_enable_xenapi:export XML=$(which xml2-config)}
export WGET=$(which true)
export GIT=$(which true)
%{?_enable_ocamltools:install -d -m 0755 %buildroot%_libdir/ocaml/stublibs}
%{?_with_efi:install -d -m 0755 %buildroot/boot/efi/efi/altlinux}
%make_install DESTDIR=%buildroot %{?_with_efi:LD_EFI=x86_64-pc-mingw32-ld}

%{?_with_efi:mv %buildroot/boot/efi/efi %buildroot/boot/efi/EFI}

%if_enabled xsmpolicy
# policy file should be in /boot/flask
install -d -m 0755 %buildroot/boot/flask
mv %buildroot/boot/xenpolicy* %buildroot/boot/flask/
%endif

############ kill unwanted stuff ############

# hypervisor symlinks
%{!?_with_hypervisor:rm -rf %buildroot/boot}

# silly doc dir fun
mv %buildroot%_docdir/%name{,-%version}
install -p -m 0644 COPYING README %buildroot%_docdir/%name-%version/
mv %buildroot%_docdir/%name-%version/{html/,}misc

# README's not intended for end users
rm -f %buildroot/%_sysconfdir/%name/README*

# adhere to Static Library Packaging Guidelines
rm -f %buildroot%_libdir/*.a

############ fixup files in /etc ############

# logrotate
install -pD -m 0644 %SOURCE4 %buildroot%_logrotatedir/%name
install -pD -m 0644 %SOURCE49 %buildroot%_tmpfilesdir/%name.conf

############ create dirs in /var ############
#install -d -m 0700 %buildroot%_localstatedir/%name/save
install -d -m 0700 %buildroot%_localstatedir/xenstored
#install -d -m 0700 %buildroot%_logdir/%name/console

############ assemble license files ############
# avoid licensedir to avoid recursion, also stubdom/ioemu and dist
# which are copies of files elsewhere
find . \
	-path %buildroot%_docdir/%name-%version/licenses -prune -o \
	-path stubdom/ioemu -prune -o \
	-path dist -prune -o \
	-name COPYING -o \
	-name LICENSE |
while read f; do
	install -pD -m 0644 {,%buildroot%_docdir/%name-%version/licenses/}$f
done

%ifarch %x86_64
rm -fr %buildroot%_docdir/%name-%version/licenses/stubdom/lwip-x86_32
rm -fr %buildroot%_docdir/%name-%version/licenses/stubdom/polarssl-x86_32
rm -fr %buildroot%_docdir/%name-%version/licenses/tools/firmware/xen-dir

mv %buildroot%_docdir/%name-%version/licenses/stubdom/lwip-x86_64 %buildroot%_docdir/%name-%version/licenses/stubdom/lwip
mv %buildroot%_docdir/%name-%version/licenses/stubdom/polarssl-x86_64 %buildroot%_docdir/%name-%version/licenses/stubdom/polarssl
mv %buildroot%_docdir/%name-%version/licenses/stubdom/gmp-x86_64 %buildroot%_docdir/%name-%version/licenses/stubdom/gmp
%endif

%ifarch %ix86
mv %buildroot%_docdir/%name-%version/licenses/stubdom/lwip-x86_32 %buildroot%_docdir/%name-%version/licenses/stubdom/lwip
mv %buildroot%_docdir/%name-%version/licenses/stubdom/polarssl-x86_32 %buildroot%_docdir/%name-%version/licenses/stubdom/polarssl
mv %buildroot%_docdir/%name-%version/licenses/stubdom/gmp-x86_32 %buildroot%_docdir/%name-%version/licenses/stubdom/gmp
%endif

install -pD -m 0755 %SOURCE5 %buildroot%_initddir/%name-qemu-dom0
mv %buildroot%_unitdir/%name-qemu-dom0-disk-backend.service %buildroot%_unitdir/%name-qemu-dom0.service

############ all done now ############

%ifdef brp_strip_none
%brp_strip_none %_datadir/%name/qemu/* %_datadir/qemu-%name/qemu/*
%else
%add_strip_skiplist %_datadir/%name/qemu/* %_datadir/qemu-%name/qemu/*
%endif

%add_verify_elf_skiplist %_datadir/%name/qemu/openbios-* %_datadir/qemu-%name/qemu/* /boot/*


%post
%post_service xen-watchdog
%post_service xencommons
%post_service xendomains
%post_service xendriverdomain


%preun
%preun_service xendriverdomain
%preun_service xendomains
%preun_service xencommons
%preun_service xen-watchdog


%files
%dir %attr(0700,root,root) %_sysconfdir/%name
%dir %attr(0700,root,root) %_sysconfdir/%name/auto
%dir %attr(0700,root,root) %_sysconfdir/%name/scripts

%_sysconfdir/%name/scripts/*

%config(noreplace) %_sysconfdir/%name/cpupool
%config(noreplace) %_sysconfdir/%name/xl.conf
%config(noreplace) %_sysconfdir/%name/xlexample*

%config(noreplace) %_sysconfdir/sysconfig/xencommons
%config(noreplace) %_sysconfdir/sysconfig/xendomains

%_initddir/xen-watchdog
%_initddir/xencommons
%_initddir/xendomains
%_initddir/xendriverdomain

%_sysconfdir/bash_completion.d

# Rotate console log files
%config(noreplace) %_sysconfdir/logrotate.d/%name

%dir /lib/systemd
%dir %_unitdir

%_unitdir/proc-xen.mount
%_unitdir/var-lib-xenstored.mount

%_unitdir/xen-init-dom0.service
%_unitdir/xen-watchdog.service
%_unitdir/xenconsoled.service
%_unitdir/xendomains.service
%_unitdir/xenstored.service
%_unitdir/xendriverdomain.service

%_tmpfilesdir/xen.conf

%dir %_libexecdir/%name
%dir %_libexecdir/%name/bin
%_libexecdir/%name/bin/init-xenstore-domain
%_libexecdir/%name/bin/libxl-save-helper

%_libexecdir/%name/bin/xen-init-dom0
%_libexecdir/%name/bin/xenconsole
%_libexecdir/%name/bin/xendomains
%_libexecdir/%name/bin/xenctx
%_libexecdir/%name/bin/xenpvnetboot

%_bindir/xencov_split
%_bindir/xenstore
%_bindir/xenstore-chmod
%_bindir/xenstore-control
%_bindir/xenstore-exists
%_bindir/xenstore-list
%_bindir/xenstore-ls
%_bindir/xenstore-read
%_bindir/xenstore-rm
%_bindir/xenstore-watch
%_bindir/xenstore-write
%_bindir/xentrace_format

%_sbindir/flask-get-bool
%_sbindir/flask-getenforce
%_sbindir/flask-label-pci
%_sbindir/flask-loadpolicy
%_sbindir/flask-set-bool
%_sbindir/flask-setenforce
%_sbindir/xen-diag
%_sbindir/xen-livepatch
%_sbindir/xen-ringwatch
%_sbindir/xen-tmem-list-parse
%_sbindir/xenbaked
%_sbindir/xenconsoled
%_sbindir/xencov
%_sbindir/xenlockprof
%_sbindir/xenmon.py
%_sbindir/xenperf
%_sbindir/xenpm
%_sbindir/xenpmd
%_sbindir/xenstored
%_sbindir/xentop
%_sbindir/xentrace
%_sbindir/xentrace_setmask
%_sbindir/xentrace_setsize
%_sbindir/xenwatchdogd
%_sbindir/xl

# man pages
%_man1dir/xenstore*
%_man1dir/xentop.*
%_man1dir/xentrace_format.*
%_man1dir/xl.*
%_man5dir/xl.cfg.*
%_man5dir/xl.conf.*
%_man5dir/xlcpupool.cfg.*
%_man5dir/xl-disk-configuration.*
%_man5dir/xl-network-configuration.5.xz
%_man7dir/xen-pci-device-reservations.*
%_man7dir/xen-pv-channel.7.xz
%_man7dir/xen-tscmode.*
%_man7dir/xen-vtpm.*
%_man7dir/xen-vtpmmgr.*
%_man8dir/xentrace.*
%_man7dir/xl-numa-placement.7.xz

%ifarch %ix86 %x86_64
%_libexecdir/%name/bin/lsevtchn
%_libexecdir/%name/bin/readnotes
%_libexecdir/%name/bin/xenpaging

%_bindir/qemu-img-xen
%_bindir/qemu-nbd-xen
%_bindir/xen-cpuid
%_bindir/xen-detect
%_bindir/xenalyze

%_sbindir/gdbsx
%_sbindir/kdd
%_sbindir/xen-hptool
%_sbindir/xen-hvmcrash
%_sbindir/xen-hvmctx
%_sbindir/xen-lowmemd
%_sbindir/xen-mfndump
%endif


# Xen logfiles
%dir %attr(0700,root,root) %_localstatedir/xen
%dir %attr(0700,root,root) %_localstatedir/xenstored
%dir %attr(0700,root,root) %_logdir/xen


%files -n lib%name
%_libdir/*.so.*
%_libdir/fs


%files -n lib%name-devel
%_libdir/*.so

%_includedir/*.h
%_includedir/%name
%_includedir/%{name}store-compat

%_datadir/pkgconfig/xen*.pc
%_datadir/pkgconfig/xlutil.pc


%post runtime
%post_service xen-qemu-dom0


%preun runtime
%preun_service xen-qemu-dom0


%files runtime
%_bindir/pygrub
%_bindir/xencons

%_initddir/%name-qemu-dom0

%dir /lib/systemd
%dir %_unitdir
%_unitdir/xen-qemu-dom0.service

%dir %_libexecdir/%name

%dir %_libexecdir/%name/bin
%_libexecdir/%name/bin/ivshmem-client
%_libexecdir/%name/bin/ivshmem-server
%_libexecdir/%name/bin/qemu-img
%_libexecdir/%name/bin/qemu-io
%_libexecdir/%name/bin/qemu-nbd
%_libexecdir/%name/bin/qemu-system-i386
%_libexecdir/%name/bin/virtfs-proxy-helper

%dir %_libexecdir/%name/libexec
%_libexecdir/%name/libexec/qemu-bridge-helper

%python_sitelibdir/%name
%python_sitelibdir/xen-*.egg-info
%python_sitelibdir/grub
%python_sitelibdir/pygrub-*.egg-info
%python_sitelibdir/fsimage.so

%ifarch %ix86 %x86_64
%dir %_libexecdir/%name/boot
%_libexecdir/%name/boot/hvmloader
%_libexecdir/%name/bin/qemu-dm
%endif

%ifarch %x86_64
%_libexecdir/%name/boot/xen-shim
%endif

%attr(0700,root,root) %_logdir/%name

%_sbindir/xen-bugtool

%dir %_libexecdir/%name/bin
%_libexecdir/%name/bin/pygrub
%_libexecdir/%name/bin/convert-legacy-stream
%_libexecdir/%name/bin/verify-stream-v2

%_datadir/qemu-%name

%ifarch %ix86 %x86_64
%_datadir/%name
%endif

%exclude %_datadir/qemu-%name/qemu/s390-ccw.img
%exclude %_datadir/qemu-%name/qemu/s390-netboot.img


%if_with hypervisor
%files hypervisor
/boot/xen*
%{?_enable_xsmpolicy:/boot/flask}
%{?_with_efi:%_efi_bindir}
%{?_with_efi:%_efi_bootdir}
%endif


%files doc
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version/misc
%doc %_docdir/%name-%version/html
%doc %_docdir/%name-%version/README


%files licenses
%dir %_docdir/%name-%version
%doc %_docdir/%name-%version/licenses
%doc %_docdir/%name-%version/COPYING


%if_enabled ocamltools
%files ocaml
%_libdir/ocaml/%{name}*
%_libdir/ocaml/stublibs/*
%exclude %_libdir/ocaml/%{name}*/*.cmxa
%exclude %_libdir/ocaml/%{name}*/*.cmx

%_sbindir/oxenstored

%dir %attr(0700,root,root) %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/oxenstored.conf


%files ocaml-devel
%_libdir/ocaml/%{name}*/*.cmxa
%_libdir/ocaml/%{name}*/*.cmx
%endif


%ifarch %ix86 %x86_64
%files stubdoms
%dir %_libexecdir/%name
%dir %_libexecdir/%name/bin
%dir %_libexecdir/%name/boot

%_libexecdir/%name/bin/stubdom-dm
%_libexecdir/%name/bin/stubdompath.sh

%_libexecdir/%name/boot/ioemu-stubdom.gz
%_libexecdir/%name/boot/pv-grub-x86_*.gz
%_libexecdir/%name/boot/xenstore-stubdom.gz

%{?_enable_vtpm:%_libexecdir/%name/boot/vtpm*.gz}
%endif


%changelog
