Name: xfwm4
Version: 4.14.6
Release: alt1

%def_enable epoxy

Summary: Window manager for Xfce
Summary (ru_RU.UTF8): Менеджер окон для окружения рабочего стола Xfce
License: GPLv2+
Group: Graphical desktop/XFce
Url: https://www.xfce.org/
Packager: Xfce Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/xfce/xfwm4.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildPreReq: rpm-build-xfce4 xfce4-dev-tools
BuildPreReq: libxfce4ui-gtk3-devel libxfconf-devel

BuildRequires: gnome-doc-utils xml-utils xsltproc
BuildRequires: intltool libSM-devel libXcomposite-devel libXdamage-devel libXext-devel libXrandr-devel libglade-devel
BuildRequires: libstartup-notification-devel libwnck3-devel xorg-cf-files
BuildRequires: libXinerama-devel libXpresent-devel libXres-devel
# For svg support in the glib-compile-resources
BuildRequires: librsvg
%{?_enable_epoxy:BuildRequires: libepoxy-devel}

Requires: xfce4-common

%define _unpackaged_files_terminate_build 1

%description
%name is a window manager for Xfce which complies to the standards
defined at http://www.freedesktop.org/.

%description -l ru_RU.UTF8
Данный пакет содержит в себе менеджер окон для окружения рабочего стола
Xfce.

%prep
%setup
%patch -p1

%build
# Don't use git tag in version.
%xfce4_drop_gitvtag xfwm4_version_tag configure.ac.in
%xfce4reconf
%configure \
	--disable-static \
	--enable-maintainer-mode \
	--enable-startup-notification \
	--enable-randr \
	--enable-render \
	--enable-xsync \
	--enable-xpresent \
	--enable-compositor \
	%{subst_enable epoxy} \
	--disable-silent-rules \
	--enable-debug=minimum

%make_build

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%doc README TODO AUTHORS
%_bindir/*
%_datadir/%name
%_desktopdir/*
%_liconsdir/*
%_iconsdir/hicolor/scalable/apps/*
%_iconsdir/hicolor/*/actions/*
%_datadir/themes/*
%_libdir/xfce4/*

%changelog
