Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires: rpm-build-java unzip
# END SourceDeps(oneline)
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define version 2.0.6
%global oname xmlsec
%global _version %(echo %{version} | tr . _ )

Name:           xml-security
Version:        2.0.6
Release:        alt1_5jpp8
Epoch:          0
Summary:        Implementation of W3C security standards for XML
License:        ASL 2.0
URL:            http://santuario.apache.org/
Source0:        http://www.apache.org/dist/santuario/java-library/%{_version}/%{oname}-%{version}-source-release.zip
# Unavailable class in jetty8/9 org.eclipse.jetty.io.Buffer
Patch0:         xml-security-2.0.2-remove-Buffer.patch

BuildRequires:  maven-local
BuildRequires:  mvn(commons-codec:commons-codec)
BuildRequires:  mvn(junit:junit)
BuildRequires:  mvn(log4j:log4j:1.2.17)
BuildRequires:  mvn(org.apache:apache:pom:)
BuildRequires:  mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires:  mvn(org.bouncycastle:bcprov-jdk15on)
BuildRequires:  mvn(org.codehaus.woodstox:woodstox-core-asl)
BuildRequires:  mvn(org.eclipse.jetty:jetty-server)
BuildRequires:  mvn(org.eclipse.jetty:jetty-servlet)
BuildRequires:  mvn(org.eclipse.jetty:jetty-servlets)
BuildRequires:  mvn(org.jvnet.jaxb2.maven2:maven-jaxb22-plugin)
BuildRequires:  mvn(org.slf4j:slf4j-api)
BuildRequires:  mvn(org.slf4j:slf4j-log4j12)
BuildRequires:  mvn(xalan:xalan)
BuildRequires:  mvn(xerces:xercesImpl)
BuildRequires:  mvn(xml-apis:xml-apis)
BuildRequires:  mvn(xmlunit:xmlunit)

BuildArch:      noarch
Source44: import.info

%description
The XML Security project is aimed at providing implementation
of security standards for XML. Currently the focus is on the
W3C standards :
- XML-Signature Syntax and Processing; and
- XML Encryption Syntax and Processing.

%package javadoc
Group: Development/Java
Summary:        Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains javadoc for %{name}.

%package demo
Group: Development/Java
Summary:        Samples for %{name}

%description demo
Samples for %{name}.

%prep
%setup -q -n %{oname}-%{version}
%pom_xpath_set "pom:properties/pom:jetty.version" 9.0.5.v20130815
%patch0 -p0

%pom_remove_plugin :maven-pmd-plugin
%pom_remove_plugin :maven-source-plugin
%pom_remove_plugin :animal-sniffer-maven-plugin
# Use org.codehaus.mojo:extra-enforcer-rules:jar:1.0-beta-3
%pom_remove_plugin :maven-enforcer-plugin
%pom_xpath_remove "pom:plugin[pom:artifactId = 'maven-javadoc-plugin']/pom:executions"

%pom_xpath_set "pom:plugin[pom:groupId = 'org.jvnet.jaxb2.maven2' ]/pom:artifactId" maven-jaxb22-plugin

%pom_xpath_remove "pom:profiles/pom:profile[pom:id = 'eclipse.moxy']"

# javax.xml.crypto.MarshalException: ECKeyValue not supported
rm -r src/test/java/javax/xml/crypto/test/dsig/InteropXMLDSig11Test.java
# UnrecoverableKey
rm -r src/test/java/javax/xml/crypto/test/dsig/PKSignatureAlgorithmTest.java \
 src/test/java/org/apache/xml/security/test/dom/algorithms/DigestAlgorithmTest.java \
 src/test/java/org/apache/xml/security/test/dom/algorithms/PKSignatureAlgorithmTest.java \
 src/test/java/org/apache/xml/security/test/dom/signature/ECDSASignatureTest.java

# Fails for various reason
rm -r src/test/java/org/apache/xml/security/test/stax/signature/IAIKTest.java \
 src/test/java/org/apache/xml/security/test/stax/signature/SignatureVerificationReferenceURIResolverTest.java \
 src/test/java/org/apache/xml/security/test/stax/signature/SignatureDigestVerificationTest.java \
 src/test/java/org/apache/xml/security/test/dom/algorithms/SymmetricEncryptionAlgorithmTest.java \
 src/test/java/org/apache/xml/security/test/dom/encryption/XMLEncryption11Test.java \
 src/test/java/org/apache/xml/security/test/stax/encryption/XMLEncryption11Test.java \
 src/test/java/org/apache/xml/security/test/stax/XMLSecurityStreamWriterTest.java \
 src/test/java/org/apache/xml/security/test/stax/signature/PKSignatureCreationTest.java \
 src/test/java/org/apache/xml/security/test/stax/signature/SignatureDigestCreationTest.java \
 src/test/java/org/apache/xml/security/test/stax/signature/PKSignatureVerificationTest.java \
 src/test/java/org/apache/xml/security/test/stax/transformer/TransformEnvelopedSignatureTest.java \
 src/test/java/org/apache/xml/security/test/stax/transformer/TransformIdentityTest.java \
 src/test/java/org/apache/xml/security/test/stax/XMLSecurityEventWriterTest.java \
 src/test/java/org/apache/xml/security/test/stax/signature/SignatureCreationTest.java \
 src/test/java/org/apache/xml/security/test/stax/signature/SignatureEncryptionTest.java \
 src/test/java/org/apache/xml/security/test/stax/signature/PhaosTest.java \
 src/test/java/org/apache/xml/security/test/dom/interop/BaltimoreTest.java \
 src/test/java/org/apache/xml/security/test/stax/signature/BaltimoreTest.java \
 src/test/java/org/apache/xml/security/test/stax/encryption/SymmetricEncryptionVerificationTest.java \
 src/test/java/org/apache/xml/security/test/stax/encryption/SymmetricEncryptionCreationTest.java \
 src/test/java/javax/xml/crypto/test/dsig/SignatureDigestMethodTest.java \
 src/test/java/org/apache/xml/security/test/stax/signature/SignatureVerificationTest.java \
 src/test/java/org/apache/xml/security/test/stax/XMLSecEventTest.java

# NoSuchAlgorithmException: unsupported algorithm
rm -r src/test/java/javax/xml/crypto/test/dsig/HMACSignatureAlgorithmTest.java
# KeyException: ECKeyValue not supported
rm -r src/test/java/javax/xml/crypto/test/dsig/CreateInteropXMLDSig11Test.java

%mvn_file :%{oname} %{name} %{oname}

%build

# On ARM builder test suite fails @ random
# java.lang.NoClassDefFoundError: Could not initialize class org.apache.xml.security.stax.ext.XMLSec
%mvn_build -f

%install
%mvn_install

chmod 644 samples/org/apache/xml/security/samples/encryption/*.java
install -d -m 755 $RPM_BUILD_ROOT%{_datadir}/%{name}
cp -pr samples/* $RPM_BUILD_ROOT%{_datadir}/%{name}

%files -f .mfiles
%doc --no-dereference LICENSE NOTICE

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE NOTICE

%files demo
%{_datadir}/%{name}
%doc --no-dereference LICENSE NOTICE

%changelog
