# TODO: build to upstream
Name: zopfli
Version: 1.0.2
Release: alt3

Summary: Zlib compatible better compressor

License: ASL 2.0
Group: File tools
Url: https://github.com/google/zopfli

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/google/%name/archive/%name-%version.tar.gz
Source: %name-%version.tar

# https://github.com/google/zopfli/pull/92
Patch: 0001-Honor-user-C-XX-FLAGS.patch

BuildRequires: gcc-c++

%add_optflags -Wno-unused-function
%add_optflags -D_FILE_OFFSET_BITS=64

%description
Zopfli is a compression algorithm bit-stream compatible with
compression used in gzip, Zip, PNG, HTTP requests, and others. Zopfli
compresses more (~5 percent) but is slower (~100x) and uses more CPU, and is
hence best suited for applications where data is compressed once and
sent over a network many times, for example, static content for the
web.

%package -n lib%name
Summary: Zopfli compress/decompress libraries
Group: System/Libraries

%description -n lib%name
Zopfli is a compression algorithm bit-stream compatible with
compression used in gzip, Zip, PNG, HTTP requests, and others. Zopfli
compresses more (~5 percent) but is slower (~100x) and uses more CPU, and is
hence best suited for applications where data is compressed once and
sent over a network many times, for example, static content for the
web.

This package provides Zopfli compress/decompress shared libraries.

%package -n lib%name-devel
Summary: Zopfli compress/decompress libraries
Group: Development/C++
Requires: lib%name = %version-%release

%description -n lib%name-devel
Zopfli is a compression algorithm bit-stream compatible with
compression used in gzip, Zip, PNG, HTTP requests, and others. Zopfli
compresses more (~5 percent) but is slower (~100x) and uses more CPU, and is
hence best suited for applications where data is compressed once and
sent over a network many times, for example, static content for the
web.

This package provides development files for Zopfli compress/decompress
libraries.


%prep
%setup

%build
# TODO: use cmake
# TODO: add LDFLAGS with -lm
%make_build CFLAGS="%optflags -lm" \
    zopfli
%make_build CFLAGS="%optflags -lm" \
    zopflipng
mkdir static && cp zopfli zopflipng static/
make clean

%make_build CFLAGS="%optflags -lm" CXXFLAGS="%optflags" \
    libzopfli
%make_build CFLAGS="%optflags -lm" CXXFLAGS="%optflags" \
    libzopflipng

%install
mkdir -p %buildroot{%_bindir,%_libdir,%_includedir}
install -m 0755 static/zopfli static/zopflipng %buildroot%_bindir/
install -m 0644 libzopfli.so.%version libzopflipng.so.%version %buildroot%_libdir/
install -m 0644 src/zopflipng/zopflipng_lib.h %buildroot%_includedir/
install -m 0644 src/zopfli/zopfli.h %buildroot%_includedir/
# FIXME:
ln -s libzopfli.so.1 %buildroot%_libdir/libzopfli.so
ln -s libzopfli.so.%version %buildroot%_libdir/libzopfli.so.1
ln -s libzopflipng.so.1 %buildroot%_libdir/libzopflipng.so
ln -s libzopflipng.so.%version %buildroot%_libdir/libzopflipng.so.1

%files
%doc COPYING
%doc CONTRIBUTORS README README.zopflipng
%_bindir/zopfli
%_bindir/zopflipng

%files -n lib%name
%_libdir/libzopfli.so.*
%_libdir/libzopflipng.so.*

%files -n lib%name-devel
%_libdir/libzopfli.so
%_libdir/libzopflipng.so
%_includedir/zopflipng_lib.h
%_includedir/zopfli.h
%doc README


%changelog
