Name: 0ad
Epoch: 1
Version: 0.0.23b
Release: alt3

Group: Games/Strategy
Summary: Free, open-source realtime strategy game of ancient warfare
License: Various (all distributable)
Url: http://www.wildfiregames.com/0ad/
Requires: %name-data = %epoch:%version
Source: %name-%version.tar
Patch0: mozjs38-jit-none.patch
Patch1: 0ad-ppc64le.patch

BuildRequires: gcc-c++ python cmake
BuildRequires: boost-filesystem-devel boost-flyweight-devel boost-signals-devel
BuildRequires: libjpeg-devel libpng-devel libvorbis-devel
BuildRequires: libopenal-devel libGL-devel libSDL2-devel libwxGTK3.0-devel libXcursor-devel
BuildRequires: libcurl-devel libxml2-devel libnspr-devel libicu-devel zlib-devel
BuildRequires: libenet-devel libminiupnpc-devel libgloox-devel libsodium-devel
BuildRequires: python-devel python-module-json

# premake5 requires /proc/self/exe
BuildRequires: /proc

%description
0 A.D. (pronounced "zero ey-dee") is a free, open-source, cross-platform
real-time strategy (RTS) game of ancient warfare. In short, it is a
historically-based war/economy game that allows players to relive or
rewrite the history of Western civilizations, focusing on the years
between 500 B.C. and 500 A.D. The project is highly ambitious, involving
state-of-the-art 3D graphics, detailed artwork, sound, and a flexible
and powerful custom-built game engine.

The game has been in development by Wildfire Games (WFG), a group of
volunteer, hobbyist game developers, since 2001. The code and data are
available under the GPL license, and the art, sound and documentation
are available under CC-BY-SA. In short, we consider 0 A.D. an an
educational celebration of game development and ancient history.

%prep
%setup
cp -p %{P:0} libraries/source/spidermonkey/FixJitNone.diff
echo "patch -p0 <../FixJitNone.diff" >>libraries/source/spidermonkey/patch.sh
%patch1 -p1

%build
mkdir -p libraries/source/fcollada/src/output/debug/FCollada
export CFLAGS="%optflags"
export CPPFLAGS="%optflags"
export SHELL=/bin/sh
[ -n "$NPROCS" ] || NPROCS=%__nprocs
build/workspaces/update-workspaces.sh \
	--bindir=%_bindir \
	--datadir=%_datadir/%name \
	--libdir=%_libdir/%name \
	-j$NPROCS
%make_build -C build/workspaces/gcc verbose=1

%install
install -Dm 0755 binaries/system/pyrogenesis %buildroot%_bindir/pyrogenesis
install -Dm 0755 binaries/system/libCollada.so %buildroot%_libdir/%name/libCollada.so
install -Dm 0755 binaries/system/libAtlasUI.so %buildroot%_libdir/%name/libAtlasUI.so
install -Dm 0755 binaries/system/libmozjs*-ps-release.so %buildroot%_libdir/%name/
install -Dm 0755 binaries/system/libnvcore.so %buildroot%_libdir/%name/libnvcore.so
install -Dm 0755 binaries/system/libnvimage.so %buildroot%_libdir/%name/libnvimage.so
install -Dm 0755 binaries/system/libnvmath.so %buildroot%_libdir/%name/libnvmath.so
install -Dm 0755 binaries/system/libnvtt.so %buildroot%_libdir/%name/libnvtt.so

install -Dm 0644 build/resources/0ad.desktop %buildroot%_desktopdir/%name.desktop
install -Dm 0644 build/resources/0ad.png %buildroot%_pixmapsdir/%name.png
ln -s pyrogenesis %buildroot%_bindir/0ad
mkdir -p %buildroot%_datadir/0ad
cp -a binaries/data/* %buildroot%_datadir/0ad/

%files
%doc README.txt
%_bindir/0ad
%_bindir/pyrogenesis
%_libdir/%name/*.so
%_pixmapsdir/%name.png
%_desktopdir/%name.desktop
%dir %_libdir/%name
%_datadir/0ad/*

%changelog
