# TODO: with additional buildreqs it builds
#    /usr/bin/osgQtBrowser
#    /usr/bin/osgQtWidgets
#    /usr/bin/osgqfont
#    /usr/bin/osgviewerFLTK
#    /usr/bin/osgviewerQt
#    /usr/bin/osgviewerWX


#
# Copyright (c) 2005, 2006, 2007, 2008, 2009 Ralf Corsepius, Ulm, Germany.
# Copyright (c) 2009 Michael Shigorin
# Copyright (c) 2011 Dmitry Derjavin
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.

Name: OpenSceneGraph
Version: 3.4.1
Release: alt1

Summary: High performance real-time graphics toolkit

License: OSGPL (wxWidgets, clarified LGPL)
Group: System/Libraries
Url: http://www.openscenegraph.org

Packager: Michael Shigorin <mike@altlinux.org>

# Source-url: https://github.com/openscenegraph/OpenSceneGraph/archive/OpenSceneGraph-%version.tar.gz
Source: %name-%version.tar

# thanks, Fedora
Patch1: 0001-Cmake-fixes.patch
Patch2: 0003-Unset-DOT_FONTNAME.patch
Patch3: 0005-c-11-narrowing-hacks-Work-around-c-11-erroring-out-n.patch

# Automatically added by buildreq on Wed Nov 30 2011
# optimized out: cmake-modules fontconfig fontconfig-devel fonts-ttf-liberation glib2-devel libGL-devel libGLU-devel libICE-devel libSM-devel libX11-devel libXau-devel libXcursor-devel libXext-devel libXfixes-devel libXft-devel libXi-devel libXinerama-devel libXmu-devel libXrandr-devel libXrender-devel libXt-devel libXv-devel libatk-devel libcairo-devel libcurl-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libgtk+2-devel libjpeg-devel libpango-devel libpng-devel libpoppler8-glib libqt4-core libqt4-dbus libqt4-devel libqt4-gui libqt4-network libqt4-opengl libqt4-qt3support libqt4-script libqt4-sql-sqlite libqt4-svg libqt4-webkit libqt4-xml libstdc++-devel libtiff-devel pkg-config xml-utils xorg-kbproto-devel xorg-randrproto-devel xorg-renderproto-devel xorg-xf86miscproto-devel xorg-xproto-devel zlib-devel
BuildRequires: rpm-macros-cmake cmake doxygen gcc-c++ gnuplot graphviz libInventor-devel libSDL-devel libXScrnSaver-devel libXcomposite-devel libXdmcp-devel libXpm-devel libXtst-devel libXxf86misc-devel libfreeglut-devel libgif-devel libgtkglext-devel libopenal-devel libpoppler-glib-devel librsvg-devel libxkbfile-devel libxml2-devel wget libgta-devel

#BuildRequires: libpixman-devel
BuildRequires: libtiff-devel
Requires: lib%name = %version-%release

%description
The OpenSceneGraph is an OpenSource, cross platform graphics
toolkit for the development of high performance graphics
applications such as flight simulators, games, virtual reality
and scientific visualization.  Based around the concept of
a SceneGraph, it provides an object oriented framework on top
of OpenGL freeing the developer from implementing and optimizing
low level graphics calls, and provides many additional utilities
for rapid development of graphics applications.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1

# path to install examples (instead the patch)
%__subst "s|share/OpenSceneGraph/bin|bin|" CMakeModules/OsgMacroUtils.cmake

%build
%cmake -DCMAKE_BUILD_TYPE="Release" \
      -DBUILD_OSG_EXAMPLES=ON -DBUILD_OSG_WRAPPERS=ON -DBUILD_DOCUMENTATION=ON
%cmake_build

%install
%cmakeinstall_std
# Supposed to take OpenSceneGraph data
mkdir -p %buildroot%_datadir/OpenSceneGraph

# hack for 3.4.x (it is ok since 3.6.0)
rm -rf %buildroot/usr/doc/

%files
%doc AUTHORS.txt LICENSE.txt NEWS.txt README.txt
%_bindir/osgarchive
%_bindir/osgconv
%_bindir/osgviewer
%_bindir/osgviewerGTK
%_bindir/osgfilecache

%package -n lib%name
Summary: Development files for OpenSceneGraph
Group: System/Libraries
Requires: libOpenThreads = %version-%release

%description -n lib%name
Runtime libraries files for OpenSceneGraph

%files -n lib%name
%_libdir/osgPlugins-*
%_libdir/libosg*.so.*

%package -n lib%name-devel
Summary: Development files for OpenSceneGraph
Group: Development/C++
Requires: lib%name = %version-%release
Requires: libOpenThreads-devel = %version-%release
Requires: pkgconfig

%description -n lib%name-devel
Development files for OpenSceneGraph

%files -n lib%name-devel
%doc BUILD/doc/OpenSceneGraphReferenceDocs
%_includedir/osg*
%_pkgconfigdir/openscenegraph*.pc
%_libdir/libosg*.so
%_bindir/osgversion

%package examples-SDL
Summary: OSG sample applications using SDL
Group: Development/Documentation

%description examples-SDL
OSG sample applications using SDL

%files examples-SDL
%_bindir/osgviewerSDL

# currently broken, see #25943
#package examples-fltk
#Summary: OSG sample applications using FLTK
#Group: Development/Documentation
#
#description examples-fltk
#OSG sample applications using FLTK
#
#files examples-fltk
#_bindir/osgviewerFLTK

# OpenSceneGraph-examples
%package examples
Summary: Sample applications for OpenSceneGraph
Group: Development/Documentation

%description examples
Sample applications for OpenSceneGraph

%files examples
%_bindir/osg2cpp
%_bindir/osgdatabaserevisions
%_bindir/osgfpdepth
%_bindir/osggpx
%_bindir/osggraphicscost
%_bindir/osgmultiviewpaging
%_bindir/osgoit
%_bindir/osgoutline
%_bindir/osgparticleshader
%_bindir/osgposter
#_bindir/osgqfont
%_bindir/osgshadercomposition
%_bindir/osgshadergen
%_bindir/osgtexturecompression
%_bindir/osgthreadedterrain
%_bindir/osguniformbuffer
%_bindir/osguserdata
%_bindir/osguserstats
%_bindir/osgvertexattributes
%_bindir/osgvirtualprogram
%_bindir/present3D
%_bindir/osganalysis
%_bindir/osganimationeasemotion
%_bindir/osganimationmorph
%_bindir/osganimationhardware
%_bindir/osganimationmakepath
%_bindir/osganimationnode
%_bindir/osganimationskinning
%_bindir/osganimationsolid
%_bindir/osganimationtimeline
%_bindir/osganimationviewer
%_bindir/osgautocapture
#_bindir/osgbrowser
%_bindir/osgcluster
%_bindir/osgdrawinstanced
%_bindir/osggameoflife
%_bindir/osgmemorytest
%_bindir/osgpackeddepthstencil
%_bindir/osgpdf
%_bindir/osgrobot
%_bindir/osgsidebyside
%_bindir/osgwidgetmessagebox
%_bindir/osgwidgetperformance
%_bindir/osgfont
%_bindir/osgimagesequence
%_bindir/osgkdtree
%_bindir/osgscreencapture
%_bindir/osgwidgetaddremove
%_bindir/osgwidgetbox
%_bindir/osgwidgetcanvas
%_bindir/osgwidgetframe
%_bindir/osgwidgetinput
%_bindir/osgwidgetlabel
%_bindir/osgwidgetmenu
%_bindir/osgwidgetnotebook
%_bindir/osgwidgetscrolled
%_bindir/osgwidgetshader
%_bindir/osgwidgetstyled
%_bindir/osgwidgettable
%_bindir/osgwidgetwindow
%_bindir/osggeometryshaders
%_bindir/osgmultiplerendertargets
%_bindir/osgmultitexturecontrol
%_bindir/osgocclusionquery
%_bindir/osgsharedarray
%_bindir/osgstereomatch
%_bindir/osgtext3D
%_bindir/osgthirdpersonview
%_bindir/osgdepthpeeling
%_bindir/osganimate
%_bindir/osgautotransform
%_bindir/osgbillboard
%_bindir/osgblendequation
%_bindir/osgcallback
%_bindir/osgcamera
%_bindir/osgcatch
%_bindir/osgclip
%_bindir/osgcompositeviewer
%_bindir/osgcopy
%_bindir/osgcubemap
%_bindir/osgdelaunay
%_bindir/osgdepthpartition
%_bindir/osgdistortion
%_bindir/osgfadetext
%_bindir/osgforest
%_bindir/osgfxbrowser
#_bindir/osggeodemo
%_bindir/osggeometry
%_bindir/osghangglide
%_bindir/osghud
%_bindir/osgimpostor
%_bindir/osgintersection
#_bindir/osgintrospection
%_bindir/osgkeyboard
%_bindir/osgkeyboardmouse
%_bindir/osglauncher
%_bindir/osglight
%_bindir/osglightpoint
%_bindir/osglogicop
%_bindir/osglogo
%_bindir/osgmanipulator
%_bindir/osgmotionblur
%_bindir/osgmovie
%_bindir/osgmultitexture
%_bindir/osgoccluder
%_bindir/osgpagedlod
%_bindir/osgparametric
%_bindir/osgparticle
%_bindir/osgparticleeffects
%_bindir/osgpick
%_bindir/osgplanets
%_bindir/osgpoints
%_bindir/osgpointsprite
%_bindir/osgprecipitation
%_bindir/osgprerender
%_bindir/osgprerendercubemap
%_bindir/osgreflect
%_bindir/osgscalarbar
%_bindir/osgscribe
%_bindir/osgsequence
%_bindir/osgshaders
%_bindir/osgshaderterrain
%_bindir/osgshadow
%_bindir/osgshape
%_bindir/osgsimplifier
%_bindir/osgslice
%_bindir/osgspacewarp
%_bindir/osgspheresegment
%_bindir/osgspotlight
%_bindir/osgstereoimage
%_bindir/osgteapot
%_bindir/osgterrain
%_bindir/osgtessellate
%_bindir/osgtext
%_bindir/osgtexture1D
%_bindir/osgtexture2D
%_bindir/osgtexture3D
%_bindir/osgtexturerectangle
%_bindir/osgunittests
%_bindir/osgvertexprogram
%_bindir/osgviewerGLUT
#_bindir/osgviewerWX
%_bindir/osgvolume
%_bindir/osgwindows

%_bindir/osgphotoalbum
%_bindir/osgsimulation

%_bindir/osgatomiccounter
%_bindir/osgcomputeshaders
#_bindir/osgframerenderer
%_bindir/osgkeystone
%_bindir/osgmultiplemovies
%_bindir/osgmultitouch
%_bindir/osgoscdevice
%_bindir/osgsimplegl3
%_bindir/osgsimpleshaders
%_bindir/osgtessellationshaders

%_bindir/osgSSBO
%_bindir/osgblenddrawbuffers
%_bindir/osggpucull
%_bindir/osgtexture2DArray
%_bindir/osgtransferfunction
%_bindir/osgtransformfeedback

%_datadir/OpenSceneGraph

# libOpenThreads
%package -n libOpenThreads
Summary: OpenThreads
Group: System/Libraries
Provides: OpenThreads = %name-%version

%description -n libOpenThreads
OpenThreads is intended to provide a minimal & complete Object-Oriented
(OO) thread interface for C++ programmers.  It is loosely modeled on the
Java thread API, and the POSIX Threads standards.  The architecture of
the library is designed around "swappable" thread models which are
defined at compile-time in a shared object library.

%files -n libOpenThreads
%doc AUTHORS.txt LICENSE.txt NEWS.txt README.txt
%_libdir/libOpenThreads.so.*

# libOpenThreads-devel
%package -n libOpenThreads-devel
Summary: Development files for OpenThreads
Group: Development/C++
Requires: libOpenThreads = %version-%release

%description -n libOpenThreads-devel
Development files for OpenThreads

%files -n libOpenThreads-devel
%doc BUILD/doc/OpenThreadsReferenceDocs
%_pkgconfigdir/openthreads.pc
%_libdir/libOpenThreads.so
%_includedir/OpenThreads

%changelog
