# vim: set ft=spec: -*- rpm-spec -*-

Name: PokerTH
Version: 1.1.2
Release: alt4

Summary: Texas Hold'em poker game
Group: Games/Cards
License: %gagpl3plus
Url: http://www.pokerth.net/

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-licenses >= 2.0.5-alt1

BuildRequires: boost-asio-devel boost-filesystem-devel boost-program_options-devel boost-interprocess-devel gcc-c++ libSDL-devel libSDL_mixer-devel libcurl-devel libdb4-devel libgnutls-openssl-devel libgsasl-devel qt5-base-devel

BuildPreReq: libgcrypt-devel zlib-devel libsqlite3-devel phonon-devel tinyxml-devel libircclient-devel libprotobuf-devel
BuildPreReq: protobuf-compiler

Requires: %name-data = %version-%release

%define _unpackaged_files_terminate_build 1

%description
PokerTH is a poker game written in C++/Qt5. You can play the popular
"Texas Hold'em" poker variant against up to nine computer-opponents or
play network games with people all over the world.

%package data
Summary: Data files for %name
Group: Games/Cards
BuildArch: noarch
Requires: %name = %version-%release

%description data
PokerTH is a poker game written in C++/Qt5. You can play the popular
"Texas Hold'em" poker variant against up to nine computer-opponents or
play network games with people all over the world.

This package contents data files for %name.

%prep
%setup
%patch -p1

%build
%add_optflags -fno-strict-aliasing

# regenerate protobuf files
qmake-qt5 pokerth_protocol.pro

qmake-qt5 \
	QMAKE_CFLAGS_RELEASE="%optflags" \
	QMAKE_CXXFLAGS_RELEASE="%optflags" \
	pokerth.pro
%make_build
qmake-qt5 \
	QMAKE_CFLAGS_RELEASE="%optflags" \
	QMAKE_CXXFLAGS_RELEASE="%optflags" \
	pokerth_game.pro
%make_build

%install
%makeinstall_std INSTALL_ROOT=%buildroot
mkdir -p %buildroot%_bindir
install -pm755 pokerth bin/pokerth_server %buildroot%_bindir

# remove bundled font (see ALT 25328)
rm %buildroot%_datadir/pokerth/data/fonts/DejaVuSans-Bold.ttf

%files
%_bindir/*

%files data
%_datadir/pokerth
%_desktopdir/pokerth.desktop
%_pixmapsdir/pokerth.png

%changelog
