Group: Games/Other
# BEGIN SourceDeps(oneline):
BuildRequires: pkgconfig(cairo) pkgconfig(gtk+-2.0) zlib-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           adonthell
Summary:        A 2D graphical RPG game
Version:        0.3.6
Release:        alt1_9
License:        GPLv2+
URL:            http://adonthell.nongnu.org/
Source0:        http://savannah.nongnu.org/download/%{name}/%{name}-src-%{version}.tar.gz

BuildRequires:  python3-devel
BuildRequires:  libfreetype-devel
BuildRequires:  libxml2-devel
BuildRequires:  libogg-devel
BuildRequires:  libvorbis-devel
BuildRequires:  libSDL2-devel libSDL2_mixer-devel libSDL2_ttf-devel
BuildRequires:  libpng-devel
BuildRequires:  swig
BuildRequires:  doxygen
BuildRequires:  graphviz libgraphviz
BuildRequires:  gcc-c++
Source44: import.info

%description
A 2D, graphical, single player role playing game inspired by good old
console RPGs from the 16 bit console gaming era.

This package contains the Adonthell engine. You will also need a game
package to play Adonthell. For this release, the official package is
Waste's Edge.


%package doc
Summary:        API documentation for %{name}

Group:          Documentation
Requires:       %{name} = %{version}-%{release}
BuildArch: noarch

%description doc
API documentation for %{name} generated by doxygen in HTML format.


%prep
%setup -q
# install locale files in the right place
sed -i 's|myconfig.gamedir + "/locale"|"%{_datadir}/locale"|' src/nls.cc

# remove hardcoded CFLAGS
sed -i 's|^CFLAGS|^#CFLAGS|g' configure
sed -i "s|ac_precious_vars='build_alias|'ac_precious_vars=build_alias|g" configure
%build
%configure --enable-doc
%make_build


%install
%makeinstall_std


%files
%doc --no-dereference COPYING AUTHORS
%{_bindir}/%{name}-0.3
%{_datadir}/%{name}/
%{_mandir}/man6/*

%files doc
%doc doc/devel/html


%changelog
