Name: anki2
Version: 2.1.12
Release: alt1

Summary: Flashcard program for using space repetition learning

Group: Games/Educational
License: AGPLv3+ and GPLv3+ and MIT and BSD
Url: https://apps.ankiweb.net/

# Source-url: https://apps.ankiweb.net/downloads/current/anki-%version-source.tgz
Source: %name-%version.tar

BuildArch: noarch

Conflicts: anki < %version-%release

BuildRequires(pre): rpm-build-python3

%add_python3_path %_datadir/anki/

%py3_requires pyaudio
%py3_requires sqlite3

Requires: mpv

# Automatically added by buildreq on Sat Apr 13 2019 (-bi)
BuildRequires: desktop-file-utils python3

%description
Anki is a program designed to help you remember facts (such as words
and phrases in a foreign language) as easily, quickly and efficiently
as possible. Anki is based on a theory called spaced repetition.

%prep
%setup
#rm -r thirdparty

%build
sed -e 's:@PREFIX@:%_prefix:' tools/runanki.system.in > tools/runanki.system

%install
install -pD -m755 tools/runanki.system %buildroot%_bindir/anki

mkdir -p %buildroot%_datadir/anki
cp -a anki aqt web locale %buildroot%_datadir/anki/

mkdir -p %buildroot%_man1dir
install -pm644 anki.1 %buildroot%_man1dir/

mkdir -p %buildroot%_datadir/mime/packages
install -pm644 anki.xml %buildroot%_datadir/mime/packages/

mkdir -p %buildroot%_datadir/pixmaps
install -pm644 designer/icons/anki.png %buildroot%_datadir/pixmaps/

mkdir -p %buildroot%_desktopdir
desktop-file-install --remove-category=KDE --dir %buildroot%_desktopdir \
	anki.desktop

%find_lang anki --with-qt

# hack against nonstandart place
LANGFILE=$(pwd)/anki.lang
cd %buildroot
for i in $(find .%_datadir/anki/locale/ -mindepth 1 -type d -maxdepth 1 | sed -e "s|^\.||") ; do
    lang="%%lang($(echo "$(basename $i)" | sed -e "s|_.*||")) "
    [ "$lang" = "%%lang(en)" ] && lang=''
    echo "$lang%%dir $i" >> $LANGFILE
    echo "$lang%%dir $i/LC_MESSAGES" >> $LANGFILE
done

%files -f anki.lang
%_bindir/anki
%_desktopdir/anki.desktop
%_datadir/pixmaps/anki.png
%_datadir/mime/packages/anki.xml
%dir %_datadir/anki/
%_datadir/anki/anki/
%_datadir/anki/aqt/
%_datadir/anki/web/
%_datadir/anki/locale/
%_man1dir/anki.*
%doc LICENSE* README*

%changelog
