%def_without docs

Name:    appstream
Version: 0.13.1
Release: alt0.1.b9
Summary: Utilities to generate, maintain and access the AppStream Xapian database 

# lib LGPLv2+, tools GPLv2+
License: GPLv2+ and LGPLv2+
Group:   System/Configuration/Packaging
URL:     http://www.freedesktop.org/wiki/Distributions/AppStream/Software
Source0: appstream-%{version}.tar
# VCS:   https://github.com/ximion/appstream
Patch1:  appstream-no-Wno-deprecated-copy.patch

BuildRequires(pre): meson
BuildRequires: gcc-c++
BuildRequires: ctest
BuildRequires: gettext
BuildRequires: gobject-introspection-devel
BuildRequires: gperf
BuildRequires: intltool
BuildRequires: itstool
BuildRequires: liblmdb-devel
BuildRequires: libprotobuf-lite-devel
BuildRequires: libstemmer-devel
BuildRequires: libxapian-devel
BuildRequires: libxml2-devel
BuildRequires: libyaml-devel
BuildRequires: ninja-build
BuildRequires: protobuf-compiler
%if_with docs
BuildRequires: daps
%endif
BuildRequires: qt5-base-devel
BuildRequires: xmlto
BuildRequires: gtk-doc
BuildRequires: libsoup-devel
BuildRequires: /proc

#Requires: appstream-data

%description
AppStream-Core makes it easy to access application information from the
AppStream database over a nice GObject-based interface.

%package devel
Summary:  Development files for %{name}
Group:	  Development/C
Requires: %name = %version-%release

%description devel
%{summary}.

%package qt
Summary: Qt bindings for %{name}
Group:	  System/Libraries
Requires: %name = %version-%release

%description qt
%{summary}.

%package qt-devel
Summary:  Development files for %{name}-qt bindings
Group:	  Development/KDE and QT
Requires: %name-qt = %version-%release

%description qt-devel
%{summary}.

%package doc
Summary:  Documenation for development using %{name}
Group:	  Development/Documentation
BuildArch: noarch

%description doc
%{summary}.

%prep
%setup
%patch1 -p1

%build
%meson  -Dqt=true \
%if_with docs
	-Ddocs=true \
%else
	-Ddocs=false \
%endif
	-Dstemming=true
%meson_build

%install
%meson_install
mkdir -p %{buildroot}%{_datadir}/app-info/{icons,xmls}
mkdir -p %{buildroot}/var/cache/app-info/{icons,xapian,xmls}
touch %{buildroot}/var/cache/app-info/cache.watch

%find_lang appstream

%check
#%%meson_test

%files -f appstream.lang
%doc AUTHORS LICENSE.GPLv2 LICENSE.LGPLv2.1 MAINTAINERS NEWS README.md RELEASE
%config(noreplace) %_sysconfdir/appstream.conf
%_bindir/appstreamcli
%_libdir/girepository-1.0/AppStream-1.0.typelib
%_libdir/libappstream.so.*
%dir %_datadir/app-info/
%dir %_datadir/app-info/icons
%dir %_datadir/app-info/xmls
%ghost %_cachedir/app-info/cache.watch
%dir %_cachedir/app-info
%dir %_cachedir/app-info/icons
%dir %_cachedir/app-info/xapian
%dir %_cachedir/app-info/xmls
%_man1dir/appstreamcli.1.*
%_datadir/gettext/its/metainfo.*
%_datadir/metainfo/org.freedesktop.appstream.cli.*.xml

%files devel
%_includedir/appstream/
%_libdir/libappstream.so
%_libdir/pkgconfig/appstream.pc
%_datadir/gir-1.0/AppStream-1.0.gir

%files qt
%_libdir/libAppStreamQt.so.*

%files qt-devel
%_includedir/AppStreamQt/
%_libdir/cmake/AppStreamQt/
%_libdir/libAppStreamQt.so

%files doc
%_defaultdocdir/%name
%_datadir/gtk-doc/html/%name

%changelog
