%set_verify_elf_method unresolved=relaxed

%define name2 ardour6

Name:    ardour
Version: 6.2
Release: alt1

Summary: Professional multi-track audio recording application
License: GPLv2+
Group:   Sound

Url:     http://ardour.org
Source:  %name-%version.tar
Source1: ardour6.desktop
#Source2: ardour3-3.2-ru.po
Packager: Grigory Ustinov <grenka@altlinux.org>

BuildRequires: boost-devel
BuildRequires: cppunit-devel >= 1.12.0
BuildRequires: doxygen
BuildRequires: gcc-c++
BuildRequires: graphviz
BuildRequires: libalsa-devel
BuildRequires: libarchive-devel
BuildRequires: pkgconfig(aubio) > 0.4
BuildRequires: libcurl-devel >= 7.0.0
BuildRequires: libcwiid-devel
BuildRequires: libfftw3-devel
BuildRequires: libflac-devel >= 1.2.1
BuildRequires: libgnomecanvasmm-devel
BuildRequires: libgtk+2-devel
BuildRequires: libjack-devel
BuildRequires: liblilv-devel >= 0.14
BuildRequires: liblo-devel >= 0.26
BuildRequires: liblrdf-devel >= 0.4.0
# FIXME BuildRequires: libltc-devel >= 1.1.0
BuildRequires: libogg-devel >= 1.1.2
BuildRequires: libredland-devel
BuildRequires: librubberband-devel
BuildRequires: libsamplerate-devel
BuildRequires: libserd-devel >= 0.14.0
BuildRequires: libsndfile-devel >= 1.0.18
BuildRequires: libsord-devel >= 0.8.0
BuildRequires: libsratom-devel >= 0.4.0
BuildRequires: libsuil-devel >= 0.6.0
BuildRequires: libsqlite3-devel
BuildRequires: libuuid-devel
BuildRequires: libudev-devel
BuildRequires: libusb-devel
BuildRequires: libvamp-devel
BuildRequires: libxml2-devel
BuildRequires: libxslt-devel
BuildRequires: lv2-devel >= 1.0.15
BuildRequires: /proc
BuildRequires: python-devel
BuildRequires: raptor2-devel
BuildRequires: taglib-devel

# FIXME
#Requires:      jackit
#Requires:      gtk-engines2
# For video import
#Requires:      harvid
#Requires:      xjadeo

Requires:       jack-audio-connection-kit

%description
Ardour is a digital audio workstation. You can use it to record, edit
and mix multi-track audio. You can produce your own CDs, mix video sound
tracks, or just experiment with new ideas about music and sound.

Ardour capabilities include: multi channel recording, non-destructive
editing with unlimited undo/redo, full automation support, a powerful
mixer, unlimited tracks/busses/plugins, time-code synchronization, and
hardware control from surfaces like the Mackie Control Universal.

You must have jackd running and an ALSA sound driver to use Ardour.
If you are new to jackd, try qjackctl.

See the online user manual at http://en.flossmanuals.net/ardour/index/

%prep
%setup
# Generate revision number
#echo '#include "ardour/revision.h"' > libs/ardour/revision.cc
#echo 'namespace ARDOUR { const char* revision = "%%version"; }' >> libs/ardour/revision.cc

%build
%__python ./waf configure \
    --prefix=%_prefix \
    --libdir=%_libdir \
    --configdir=%_sysconfdir \
    --program-name=Ardour \
%ifarch %e2k
    --cxx11 \
    --keepflags \
%endif
    --nls \
    --docs

%__python ./waf build \
    --nls \
    --docs

%__python ./waf i18n_mo

%install
%__python ./waf install --destdir=%buildroot

install -d -m 0755 %buildroot%_desktopdir
install -m 644 %SOURCE1 %buildroot%_desktopdir/

install -d -m 0755 %buildroot%_iconsdir
cp -f %buildroot%_datadir/%name2/icons/application-x-ardour_48px.png \
%buildroot%_iconsdir/ardour6.png

%add_findprov_lib_path %_libdir/%name2
%find_lang --output=%name.lang %name2 gtk2_ardour3 gtkmm2ext3

%files -f %name.lang
%doc README
%_bindir/*
%_libdir/%name2
%_datadir/%name2
%_desktopdir/*.desktop
%_sysconfdir/%name2
%_iconsdir/ardour6.png

%changelog
