%def_enable static
%def_without doc
%define sover 1

Name: audiofile
Version: 0.3.6
Release: alt3

Summary: Library to handle various audio file formats
License: LGPL
Group: System/Libraries
Url: http://www.68k.org/~michael/%name

# VCS https://github.com/mpruett/audiofile.git
Source: %url/%name-%version.tar
# newer pkg-config macros required
Source1: pkg.m4
Patch: %name-%version-%release.patch
Patch1: %name-0.3.6-alt-configure.patch

Requires: lib%name%sover = %version-%release

BuildRequires: gcc-c++ glibc-devel-static libalsa-devel
BuildPreReq: libflac-devel
%{?_with_doc:BuildRequires: asciidoc-a2x}

%package -n lib%name%sover
Summary: Shared library for %name
Group: System/Libraries

%package -n lib%name-devel
Summary: Includes and other files to develop %name applications
Group: Development/C
Requires: lib%name%sover = %version-%release
Provides: %name-devel = %version
Obsoletes: %name-devel

%package -n lib%name-devel-static
Summary: Static libraries to develop %name applications
Group: Development/C
Requires: lib%name-devel = %version-%release

%description
The Audio File Library handles reading and writing audio files in many
common formats.

Key goals of the Audio File Library are file format transparency and data
format transparency. The same calls for opening a file, accessing and
manipulating audio metadata (e.g. sample rate, sample format, textual
information, MIDI parameters), and reading and writing sample data will
work with any supported audio file format. Likewise, the format of the
audio data presented to the application need not be tied to the format
of the data contained in the file.

The following file formats are currently supported:
* AIFF/AIFF-C
* WAVE
* NeXT .snd/Sun .au
* Berkeley/IRCAM/CARL Sound File
* Audio Visual Research
* Amiga IFF/8SVX
* Creative Voice File
* NIST SPHERE
* Core Audio Format

The following compression formats are currently supported:
* G.711 mu-law and A-law
* IMA ADPCM
* Microsoft ADPCM

%description -n lib%name%sover
This package contains the library needed to run programs dynamically
linked with audiofile.

%description -n lib%name-devel
Include files and other resources you can use to develop
%name applications.

%description -n lib%name-devel-static
Static libraries you can use to develop
%name applications.

%prep
%setup
%patch -p1
[ ! -d m4 ] && mkdir m4 && cp %SOURCE1 m4/
%patch1 -b .m4

%build
%autoreconf
%configure \
	--enable-largefile \
	%{?!_with_doc:--disable-docs} \
	%{subst_enable static}
# SMP-incompatible build (man pages)
%make_build || %make

%install
%makeinstall_std

%check
%make check

%files
%_bindir/sfconvert
%_bindir/sfinfo
%doc README ACKNOWLEDGEMENTS TODO NEWS NOTES

%files -n lib%name%sover
%_libdir/*.so.*
%if_with doc
%_man1dir/*
%endif

%files -n lib%name-devel
%_libdir/*.so
%_pkgconfigdir/*
%_includedir/*
%if_with doc
%_man3dir/*
%endif

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
