Group: Sciences/Mathematics
# BEGIN SourceDeps(oneline):
BuildRequires: rpm-build-java unzip
# END SourceDeps(oneline)
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           axiom
Version:        1.2.14
Release:        alt1_2jpp8
Epoch:          2
Summary:        Axis Object Model
License:        ASL 2.0
Url:            http://ws.apache.org/commons/axiom/
Source0:        http://archive.apache.org/dist/ws/axiom/%{version}/axiom-%{version}-source-release.zip

Patch0:         port-to-mime4j-0.8.1.patch

BuildRequires:  maven-local
BuildRequires:  mvn(commons-io:commons-io)
BuildRequires:  mvn(commons-logging:commons-logging)
BuildRequires:  mvn(com.sun.xml.bind:jaxb-impl)
BuildRequires:  mvn(javax.mail:mail)
BuildRequires:  mvn(javax.xml.bind:jaxb-api)
BuildRequires:  mvn(jaxen:jaxen)
BuildRequires:  mvn(junit:junit)
BuildRequires:  mvn(net.sf.saxon:saxon)
BuildRequires:  mvn(org.apache:apache:pom:)
BuildRequires:  mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires:  mvn(org.apache.james:apache-mime4j-core) >= 0.8.1
BuildRequires:  mvn(org.apache.maven.doxia:doxia-core)
BuildRequires:  mvn(org.apache.maven.plugins:maven-shade-plugin)
BuildRequires:  mvn(org.codehaus.plexus:plexus-component-metadata)
BuildRequires:  mvn(org.codehaus.woodstox:stax2-api)
BuildRequires:  mvn(org.codehaus.woodstox:woodstox-core-asl)
BuildRequires:  mvn(org.jvnet.jaxb2.maven2:maven-jaxb2-plugin)
BuildRequires:  mvn(org.osgi:osgi.cmpn)
BuildRequires:  mvn(org.osgi:osgi.core)
BuildRequires:  mvn(xalan:xalan)
BuildRequires:  mvn(xerces:xercesImpl)
BuildRequires:  mvn(xmlunit:xmlunit)

Requires:       mvn(org.apache.james:apache-mime4j-core) >= 0.8.1

BuildArch:      noarch
Source44: import.info

Provides: ws-commons-%name = 0:%version-%release
Conflicts:  ws-commons-%name <= 0:1.2.12-alt2_7jpp7
Obsoletes:  ws-commons-%name <= 0:1.2.12-alt2_7jpp7


%description
AXIOM stands for AXis Object Model (also known as OM - Object Model)
and refers to the XML info-set model that was initially developed for
Apache Axis2.

%package javadoc
Group: Sciences/Mathematics
Summary:        API Documentation for %{name}
BuildArch: noarch

%description javadoc
%{summary}.

%prep
%setup -q
%patch0

# Disable plugins not needed for RPM builds
%pom_remove_plugin -r :maven-javadoc-plugin
%pom_remove_plugin -r :maven-source-plugin
%pom_remove_plugin -r :apache-rat-plugin
%pom_remove_plugin -r :gmaven-plugin

# Don't build and attach manuals due to unavailable plugin "com.agilejava.docbkx:docbkx-maven-plugin"
%pom_remove_plugin :docbkx-maven-plugin
%pom_remove_plugin :build-helper-maven-plugin

# No need to build dist assembly for RPM builds
%pom_remove_plugin :maven-assembly-plugin

# Change to modern OSGi dependencies
%pom_change_dep -r org.osgi:org.osgi.core org.osgi:osgi.core
%pom_change_dep -r org.osgi:org.osgi.compendium org.osgi:osgi.cmpn

# Mordern JREs supply these APIs
%pom_remove_dep :geronimo-activation_1.1_spec modules/axiom-{dom,parent,api,testutils,impl}
%pom_remove_dep :geronimo-stax-api_1.0_spec modules/axiom-{tests,parent,api,testutils,impl}

# Fix dep on mail API and saxon
%pom_change_dep :geronimo-javamail_1.4_spec javax.mail:mail:1.4 modules/axiom-{dom,parent,api,impl}
%pom_remove_dep :saxon-dom modules/axiom-dom-testsuite

# This plugin is used to get all possible stax implementations for testing against, which
# is impossible in Fedora; removing this means only testing against the JRE implementation
%pom_remove_plugin :maven-dependency-plugin modules/axiom-api

# Disable test suites due to unavailable deps "crimson", "org.ops4j.*"
%pom_disable_module modules/axiom-osgi-tests
%pom_disable_module modules/axiom-integration

# Don't build samples
%pom_disable_module modules/axiom-samples

# Don't ship tests
%mvn_package ":*-{tests,testsuite}" __noinstall
%mvn_package ":axiom-{build,test}utils" __noinstall

%build
# Skipping tests for now due to unexplained failures
%mvn_build -- -DskipTests

%install
%mvn_install

%files -f .mfiles
%doc *.txt
%doc --no-dereference LICENSE NOTICE

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE NOTICE

%changelog
