Name: bind
Version: 9.11.37
%define src_version 9.11.37
Release: alt2.p9.1

Summary: ISC BIND - DNS server
License: MPL-2.0
Group: System/Servers
Url: http://www.isc.org/products/BIND/

# ftp://ftp.isc.org/isc/bind9/%src_version/bind-%src_version.tar.gz
Source0: %name-%version.tar
Source2: rfc1912.txt
Source3: bind.README.bind-devel
Source4: bind.README.ALT

Source11: bind.init
Source12: lwresd.init

Source21: rndc.conf
Source22: rndc.key

Source31: bind.named.conf
Source32: bind.options.conf
Source33: bind.rndc.conf
Source34: bind.local.conf
Source35: bind.rfc1912.conf
Source36: bind.rfc1918.conf
Source37: bind.sysconfig

Source41: bind.localhost
Source42: bind.localdomain
Source43: bind.127.in-addr.arpa
Source44: bind.empty

Source50: bind.service

# NB: there must be at least one patch :)
# snapshot of upstream's branch (bind-9.11), prepared with:
# git remote update
# git branch -f bind-9.11 upstream/bind-9.11
# git merge -sours bind-9.11 -m "Merge branch 'bind-9.11' into p9" -m 'Synced to:'$'\n'"$(git show --format=oneline bind-9.11)"$'\n''(https://gitlab.isc.org/isc-projects/bind9/-/tree/bind-9.11)'
# gear-store-tags -ac
Patch0000: %name-%version-%release.patch
Patch0001: 0001-owl-warnings.patch
Patch0002: 0002-openbsd-owl-pidfile.patch
Patch0003: 0003-openbsd-owl-chroot-defaults.patch
Patch0004: 0004-alt-owl-chroot.patch
Patch0005: 0005-owl-checkconf-chroot.patch
Patch0006: 0006-alt-man.patch
Patch0007: 0007-alt-nofile.patch
Patch0008: 0008-alt-ads-remove.patch
Patch0009: 0009-Minimize-linux-capabilities.patch
Patch0010: 0010-Link-libirs-with-libdns-libisc-and-libisccfg.patch
Patch0011: 0011-ALT-Make-it-possible-to-retain-Linux-capabilities-of.patch

# root directory for chrooted environment.
%define _chrootdir %_localstatedir/bind

# common directory for documentation.
%define docdir %_docdir/bind-%version

%ifndef timestamp
%define timestamp %(TZ=UTC LC_TIME=C date +%%Y%%m%%d)
%endif

%def_disable static
%def_enable ipv6
%def_with openssl
%def_with libjson
%def_without python

Provides: bind-chroot(%_chrootdir)
Obsoletes: bind-chroot, bind-debug, bind-slave, caching-nameserver
# Because of /etc/syslog.d/ feature.
Conflicts: syslogd < 1.4.1-alt11
Requires(pre): bind-control >= 1.3

# due to %_chrootdir/dev/log
BuildPreReq: coreutils

# due to broken configure script
BuildPreReq: gcc-c++

# for better --enable-linux-caps experience
BuildPreReq: libcap-devel

%{?_with_openssl:BuildPreReq: libssl-devel}
%{?_with_libjson:BuildPreReq: libjson-c-devel}
BuildPreReq: libkrb5-devel

%package utils
Summary: Utilities provided by ISC BIND
Group: Networking/Other
Requires: libbind = %EVR

%package -n libbind
Summary: Shared library used by ISC BIND
Group: System/Libraries
Provides: libdns = %EVR
Provides: libisc = %EVR
Provides: libisccc = %EVR
Provides: libisccfg = %EVR
Provides: liblwres = %EVR
Obsoletes: libdns8, libdns9, libdns10, libdns11, libdns16
Obsoletes: libisc4, libisc7, libisccc0, libisccfg0, liblwres1

%package devel
Summary: ISC BIND development libraries and headers
Group: Development/C
Requires: libbind = %EVR
Provides: libisc-export-devel = %EVR
Obsoletes: libisc-export-devel < %version

%package devel-static
Summary: ISC BIND static development libraries
Group: Development/C
Requires: %name-devel = %EVR

%package doc
Summary: Documentation for ISC BIND
Group: Development/Other
BuildArch: noarch
Prefix: %prefix

%package -n lwresd
Summary: Lightweight resolver daemon
Group: System/Servers
Requires: libbind = %EVR

%description
The Berkeley Internet Name Domain (BIND) implements an Internet domain
name server.  BIND is the most widely-used name server software on the
Internet, and is supported by the Internet Software Consortium (ISC).

This package provides the %src_version server and related
configuration files.

%description utils
This package contains various utilities related to DNS that are derived
from the BIND %src_version source tree, including dig, host,
nslookup and nsupdate.

%description -n libbind
This package contains shared libraries used by BIND's %src_version
daemons and clients.

%description devel
This package contains development libraries, header files, and API man
pages for libdns, libisc, libisccc, libisccfg and liblwres. These are
only needed if you want to compile packages that need more BIND
%src_version nameserver API than the resolver code provided by
glibc.

%description devel-static
This package contains development static libraries, header files, and
API man pages for libdns, libisc, libisccc, libisccfg and liblwres.
These are only needed if you want to compile statically linked packages
that need more BIND %src_version nameserver API than the resolver
code provided by glibc.

%description doc
This package provides various documents that are useful for maintaining
a working BIND %src_version installation.

%description -n lwresd
This package contains lwresd, the daemon providing name lookup services
to clients that use the BIND %src_version lightweight resolver
library. It is essentially a stripped-down, caching-only name server
that answers queries using the BIND 9 lightweight resolver protocol
rather than the DNS protocol.

%prep
%setup

# NB: there must be at least one patch :)
%autopatch -p1

install -D -pm644 %_sourcedir/rfc1912.txt doc/rfc/rfc1912.txt
install -pm644 %_sourcedir/bind.README.bind-devel README.bind-devel
install -pm644 %_sourcedir/bind.README.ALT README.ALT

mkdir addon
install -pm644 %_sourcedir/{bind,lwresd}.init addon/
install -pm644 %_sourcedir/bind.{named,options,rndc,local,rfc1912,rfc1918}.conf \
	addon/
install -pm644 %_sourcedir/bind.{localhost,localdomain,127.in-addr.arpa,empty,sysconfig,service} \
	addon/
install -pm644 %_sourcedir/rndc.{conf,key} addon/

find -type f -print0 |
	xargs -r0 grep -lZ '@[A-Z_]\+@' -- |
	xargs -r0 sed -i \
'
s,@ROOT@,%_chrootdir,g;
s,@LWRESD_ROOT@,/var/resolv,g;
s,@DOCDIR@,%docdir,g;
s,@SBINDIR@,%_sbindir,g;
' --

sed -i '/# Large File/iAC_SYS_LARGEFILE/' configure.ac

%build
%autoreconf
%configure \
	--localstatedir=/var \
	--with-randomdev=/dev/random \
	--enable-threads \
	--enable-linux-caps \
	--enable-fixed-rrset \
	--disable-seccomp \
	 %{subst_with openssl} \
	 %{subst_with libjson} \
	 %{subst_with python} \
	 %{subst_enable ipv6} \
	 %{subst_enable static} \
	--includedir=%{_includedir}/bind9 \
	--with-libtool \
	--with-gssapi=yes \
	#

%make_build
# Build queryperf
pushd contrib/queryperf
	%configure
	%make_build
popd # contrib/queryperf

%install
%makeinstall_std

# Install additional headers.
install -pm644 lib/isc/unix/errno2result.h %buildroot%_includedir/bind9/isc/

# Install queryperf.
install -pm755 contrib/queryperf/queryperf %buildroot%_sbindir/

# Install startup scripts.
install -pD -m755 addon/bind.init %buildroot%_initdir/bind
install -pD -m755 addon/lwresd.init %buildroot%_initdir/lwresd

# Install systemd service
install -pD -m644 addon/bind.service %buildroot%_unitdir/bind.service

# Install configurations files
install -pm640 addon/rndc.conf %buildroot%_sysconfdir/
install -pD -m644 addon/bind.sysconfig %buildroot%_sysconfdir/sysconfig/bind

# Create a chrooted environment...
mkdir -p %buildroot%_chrootdir/{dev,%_sysconfdir,var/{run,tmp},session,zone/slave}
for n in named options rndc local rfc1912 rfc1918; do
	install -pm640 "addon/bind.$n.conf" \
		"%buildroot%_chrootdir%_sysconfdir/$n.conf"
done
for n in localhost localdomain 127.in-addr.arpa empty; do
	install -pm640 "addon/bind.$n" \
		"%buildroot%_chrootdir/zone/$n"
	sed -i s/YYYYMMDDNN/%{timestamp}00/ \
		"%buildroot%_chrootdir/zone/$n"
done

install -pm640 addon/rndc.key bind.keys %buildroot%_chrootdir%_sysconfdir/
ln -snfr %buildroot%_sysconfdir/bind/{named.conf,bind.keys} \
	%buildroot%_sysconfdir/

# Create symlinks for unchrooted bind.
ln -snf . %buildroot%_chrootdir%_sysconfdir/bind
ln -snf ../zone %buildroot%_chrootdir%_sysconfdir/zone
ln -snfr %buildroot%_chrootdir%_sysconfdir %buildroot%_sysconfdir/bind

# Make use of syslogd-1.4.1-alt11 /etc/syslog.d/ feature.
/usr/bin/mksock %buildroot%_chrootdir/dev/log
mkdir %buildroot%_sysconfdir/syslog.d
ln -s %_chrootdir/dev/log %buildroot%_sysconfdir/syslog.d/bind
#... end of the chroot configuration.

# Create ndc compatibility symlinks.
ln -s rndc %buildroot%_sbindir/ndc
ln -s rndc.8 %buildroot%_man8dir/ndc.8

# Create ghost files
touch %buildroot/var/run/{named,lwresd}.pid

# Package documentation files
mkdir -p %buildroot%docdir
cp -a CHANGES COPYRIGHT README* \
	doc/{arm,misc,rfc} \
	%buildroot%docdir/
install -pm644 contrib/queryperf/README %buildroot%docdir/README.queryperf

xz -9 %buildroot%docdir/{*/*.txt,CHANGES}
rm -v %buildroot%docdir/*/{Makefile*,README-SGML,*.xml}

%define _unpackaged_files_terminate_build 1

%pre
/usr/sbin/groupadd -r -f named
/usr/sbin/useradd -r -g named -d %_chrootdir -s /dev/null -n -c "Domain Name Server" named >/dev/null 2>&1 ||:
[ -f %_initdir/named -a ! -L %_initdir/named ] && /sbin/chkconfig --del named ||:
%pre_control bind-chroot bind-debug bind-slave bind-caps

%preun
%preun_service bind

%post
SYSLOGD_SCRIPT=/etc/init.d/syslogd
SYSLOGD_CONFIG=/etc/sysconfig/syslogd
if grep -qs '^SYSLOGD_OPTIONS=.*-a %_chrootdir/dev/log' "$SYSLOGD_CONFIG"; then
	# Remove artefacts of pre-syslog.d epoch.
	sed -i 's|^\(SYSLOGD_OPTIONS=.*\) \?-a %_chrootdir/dev/log|\1|' "$SYSLOGD_CONFIG"
	if [ -x "$SYSLOGD_SCRIPT" ]; then
		"$SYSLOGD_SCRIPT" condreload ||:
	fi
fi

%post_control -s enabled bind-chroot
%post_control -s disabled bind-debug bind-slave bind-caps
%post_service bind

%pre -n lwresd
/usr/sbin/groupadd -r -f lwresd
/usr/sbin/useradd -r -g lwresd -d / -s /dev/null -n -c "Lightweight Resolver Daemon" lwresd >/dev/null 2>&1 ||:

%post -n lwresd
%post_service lwresd

%preun -n lwresd
%preun_service lwresd

%triggerun -- bind < 9.11.19-alt3
F=/etc/sysconfig/bind
if [ $2 -gt 0 -a -f $F ]; then
	grep -q '^#\?CHROOT=' $F || echo '#CHROOT="-t /"' >> $F
	grep -q '^#\?RETAIN_CAPS=' $F || echo '#RETAIN_CAPS="-r"' >> $F
fi

%files -n libbind
%_libdir/lib*.so.*
%dir %docdir
%docdir/COPYRIGHT

%files -n lwresd
%config %_initdir/lwresd
%_sbindir/lwresd
%_man8dir/lwresd.*
%ghost %attr(644,root,root) /var/run/lwresd.pid

%files devel
%_libdir/*.so
%_bindir/bind9-config
%_bindir/isc-config.sh
%_includedir/bind9
%_man1dir/bind9-config.1*
%_man3dir/*
%dir %docdir
%docdir/README.bind-devel

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%files
%_bindir/arpaname
%_bindir/named-rrchecker
%exclude %_sbindir/lwresd
%exclude %_man8dir/lwresd*
%_sbindir/*
%_sysconfdir/bind
%_sysconfdir/bind.keys
%_sysconfdir/named.conf
%config %_initdir/bind
%config %_sysconfdir/sysconfig/bind
%config(noreplace) %attr(640,root,named) %_sysconfdir/rndc.conf
%_unitdir/bind.service

%_man1dir/named-rrchecker.1*
%_man5dir/*
%_man8dir/*
%_man1dir/arpaname*

%dir %docdir
%docdir/README*
%docdir/misc
%exclude %docdir/README.bind-devel

%ghost %attr(644,root,root) /var/run/named.pid

#chroot
%_sysconfdir/syslog.d/*
%defattr(640,root,named,710)
%dir %_chrootdir
%dir %_chrootdir/dev
%dir %_chrootdir%_sysconfdir
%dir %_chrootdir/zone
%dir %attr(700,root,named) %verify(not mode) %_chrootdir/zone/slave
%dir %attr(700,root,named) %verify(not mode) %_chrootdir/var
%dir %attr(1770,root,named) %_chrootdir/var/run
%dir %attr(1770,root,named) %_chrootdir/var/tmp
%dir %attr(700,root,named) %_chrootdir/session
%config(noreplace) %_chrootdir%_sysconfdir/*.conf
%config(noreplace) %verify(not md5 mtime size) %_chrootdir%_sysconfdir/rndc.key
%_chrootdir%_sysconfdir/bind.keys
%attr(-,root,root) %_chrootdir%_sysconfdir/bind
%attr(-,root,root) %_chrootdir%_sysconfdir/zone
%config %_chrootdir/zone/localhost
%config %_chrootdir/zone/localdomain
%config %_chrootdir/zone/127.in-addr.arpa
%config %_chrootdir/zone/empty

%ghost %attr(666,root,root) %_chrootdir/dev/*

%files utils
%_bindir/delv
%_bindir/dig
%_bindir/mdig
%_bindir/host
%_bindir/nslookup
%_bindir/nsupdate
%_man1dir/delv.*
%_man1dir/dig.*
%_man1dir/mdig.*
%_man1dir/host.*
%_man1dir/nslookup.*
%_man1dir/nsupdate.*
%_man1dir/isc-config.sh.*

%files doc
%docdir
%exclude %docdir/README*
%exclude %docdir/misc
%exclude %docdir/COPYRIGHT

%changelog
