Name:     bleachbit
Version:  4.4.0
Release:  alt1

Summary:  Remove unnecessary files, free space, and maintain privacy
License:  GPL-3.0+
Group:    Archiving/Other
URL:      http://www.bleachbit.org/

Packager: Andrey Cherepanov <cas@altlinux.org>

Source0:  %name-%version.tar
Patch1:   %name-apt-rpm-specific.patch
Patch2:   %name-alt-reasonable-config.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-gnome python3-devel

%add_python3_req_skip win32api win32con win32file winioctlcon
%add_python3_path %_datadir/%name
%filter_from_provides /^python3(/d

%description
BleachBit deletes unnecessary files to free valuable disk space,
maintain privacy, and remove junk. Rid your system of old clutter
including cache, cookies, Internet history, localizations, logs,
temporary files, and broken shortcuts. It wipes clean the cache
and history list of many common programs.

%prep
%setup -q
%patch1 -p1
%patch2 -p1

%build
make -C po local 
%python3_build

%install
%makeinstall_std prefix=%_prefix
# Create desktop file to run BleachBit as Administrator
pushd %buildroot%_desktopdir
cp org.bleachbit.BleachBit.desktop org.bleachbit.BleachBit-root.desktop
subst 's/^Name=BleachBit$/Name=BleachBit as Administrator/g' org.bleachbit.BleachBit-root.desktop
subst 's/^GenericName\[ru\]=.*$/GenericName[ru]=Очистка от ненужных файлов (с правами администратора)/' org.bleachbit.BleachBit-root.desktop
subst 's/^Exec=bleachbit$/Exec=pkexec bleachbit/g' org.bleachbit.BleachBit-root.desktop
popd
subst '/^#!\//, 1d' %buildroot%_datadir/bleachbit/CLI.py
subst '/^#!\//, 1d' %buildroot%_datadir/bleachbit/GUI.py
rm -f %buildroot%_datadir/%name/Windows.py*

%find_lang %name

%files -f %name.lang
%doc COPYING README.md
%_bindir/%name
%_desktopdir/*.desktop
%_datadir/%name/
%_pixmapsdir/%name.png
%_datadir/metainfo/*.metainfo.xml
%_datadir/polkit-1/actions/*.policy

%changelog
