%define git %nil
%define _libexecdir %_prefix/libexec
%def_enable obex
%def_enable btpclient
# since 5.44 the following tools marked as deprecated:
# hciattach hciconfig hcitool hcidump rfcomm sdptool ciptool gatttool
%def_enable deprecated

Name: bluez
Version: 5.55
Release: alt2

Summary: Bluetooth utilities
License: GPL-2.0-or-later
Group: Networking/Other

Url: http://www.bluez.org/
Source: %name-%version.tar
Patch: %name-%version-%release.patch
Packager: L.A. Kostis <lakostis@altlinux.org>

# Change firmware path to correct /lib/firmware
Patch1: bluez-5.55-alt-firmware-path-fixes.patch

# fc
Patch10: 0001-Allow-using-obexd-without-systemd-in-the-user-sessio.patch
Obsoletes: obex-data-server < 0.4.6-alt3
Conflicts: udev-extras < 169
Requires(post,preun): /bin/systemctl

BuildRequires: glib2-devel libudev-devel libdbus-devel libreadline-devel
BuildRequires: systemd-devel gtk-doc
%{?_enable_obex:BuildRequires: libical-devel libicu-devel}
%{?_enable_btpclient:BuildRequires: libell-devel >= 0.28}
# for check
BuildRequires: /proc

%description
Bluetooth protocol stack for Linux

%package -n lib%name
Summary: Libraries for use in Bluetooth applications
Group: System/Libraries
Obsoletes: lib%{name}4

%description -n lib%name
Libraries for use in Bluetooth applications

%package -n lib%name-devel
Summary: Development libraries for Bluetooth applications
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
lib%name-devel contains development libraries and headers for
use in Bluetooth applications

%package cups
Summary: CUPS printer backend for Bluetooth printers
Group: Networking/Other
Requires: %name = %version-%release

%description cups
This package contains the CUPS backend

%package btpclient
Summary: Tester protocol for Bluetooth stack client
Group: Networking/Other
Requires: %name = %version-%release

%description btpclient
BTP stands for Bluetooth Tester Protocol and aims at automated testing of BT
stack. BTP is binary protocol and is already implemented in Zephyr Project.

https://github.com/zephyrproject-rtos/zephyr/blob/master/tests/bluetooth/tester/btp_spec.txt

%prep
%setup
%patch -p1
%patch1 -p1
%patch10 -p1

%build
%autoreconf
export CFLAGS="$CFLAGS %(getconf LFS_CFLAGS)"
%configure \
	--enable-library \
	--enable-threads \
	--enable-external-ell \
	%{subst_enable obex} \
	%{subst_enable btpclient} \
	--enable-cups \
	--enable-tools \
	--enable-hid2hci \
	--localstatedir=%_var \
	%{subst_enable deprecated}
%make_build

%install
%makeinstall_std
%{?_enable_deprecated:install -m755 attrib/gatttool %buildroot%_bindir/}
%{?_enable_btpclient:install -m755 tools/btpclient %buildroot%_bindir/}
install -m755 tools/bneptest %buildroot%_bindir/
install -pD -m755 scripts/bluetooth.alt.init %buildroot%_initdir/bluetoothd
ln -s bluetooth.service %buildroot%_unitdir/bluetoothd.service
mkdir -p %buildroot%_libdir/bluetooth/plugins %buildroot%_localstatedir/bluetooth
# configdir
mkdir -p %buildroot%_sysconfdir/bluetooth

find %buildroot%_libdir -name \*.la -delete

%check
%make check

%post
if [ $1 = 1 ]; then
%post_service bluetoothd
	chkconfig bluetoothd on
	/bin/systemctl --user --global preset obex.service >/dev/null 2>&1 || :
fi

%preun
if [ $1 = 0 ]; then
%preun_service bluetoothd
	/bin/systemctl --user --global disable obex.service >/dev/null 2>&1 || :
fi

%triggerin -- %name < 5.54-alt5
/bin/systemctl --user --global preset obex.service >/dev/null 2>&1 || :

%files
%doc AUTHORS ChangeLog README
%dir %_sysconfdir/bluetooth
%_initdir/bluetoothd
%config %_sysconfdir/dbus-1/system.d/bluetooth.conf
%_unitdir/*.service
%_prefix/lib/systemd/user/obex.service
/lib/udev/rules.d/*-hid2hci.rules
/lib/udev/hid2hci
%_bindir/bccmd
%_bindir/bluemoon
%_bindir/bluetoothctl
%_bindir/btattach
%_bindir/btmon
%_bindir/hex2hcd
%_bindir/l2ping
%_bindir/l2test
%_bindir/mpris-proxy
%_bindir/rctest
%_bindir/bneptest

%if_enabled deprecated
%_bindir/ciptool
%_bindir/gatttool
%_bindir/hciattach
%_bindir/hciconfig
%_bindir/hcidump
%_bindir/hcitool
%_bindir/rfcomm
%_bindir/sdptool
%endif

%_libdir/bluetooth/
%_libexecdir/bluetooth/
%_datadir/dbus-1/system-services/org.bluez.service
%_datadir/dbus-1/services/org.bluez.obex.service
%_localstatedir/bluetooth
%_man1dir/*.1*
%_man8dir/*.8*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/bluetooth
%_libdir/*.so
%_pkgconfigdir/*.pc

%files cups
%_prefix/lib/cups/backend/bluetooth

%if_enabled btpclient
%files btpclient
%_bindir/btpclient
%endif

%changelog
