%def_enable selinux
# "setuid" or "none"
%define priv_mode setuid
%if %priv_mode == "setuid"
%def_enable userns
%endif

Name: bubblewrap
Version: 0.4.1
Release: alt2

Summary: Unprivileged sandboxing tool

Group: System/Base
License: LGPLv2+
Url: https://github.com/projectatomic/bubblewrap

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/projectatomic/bubblewrap/releases/download/v%version/bubblewrap-%version.tar.xz
# VCS: https://github.com/projectatomic/bubblewrap.git
Source: %name-%version.tar
#Source: https://github.com/projectatomic/%name/releases/download/v%version/%name-%version.tar.xz

Patch1: bubblewrap-fix-run-path.patch

%if %priv_mode == "none"
Requires(pre): libcap-utils
%endif

BuildRequires: gcc-c++ binutils-devel libelf-devel
BuildRequires: db2latex-xsl docbook-style-xsl libcap-devel xsltproc
%{?_enable_selinux:BuildRequires: libselinux-devel}

%description
Many container runtime tools like systemd-nspawn, docker, etc. focus on providing
infrastructure for system administrators and orchestration tools (e.g. Kubernetes) to run containers.

These tools are not suitable to give to unprivileged users,
because it is trivial to turn such access into to a fully privileged root shell on the host.

%prep
%setup
%patch1 -p1

%build
%autoreconf
%configure \
	%{subst_enable selinux} \
	%{?_enable_userns:--enable-require-userns=yes}

%make_build

%install
%makeinstall_std

%if_enabled userns
mkdir -p %buildroot%_sysctldir
cat > %buildroot%_sysctldir/90-bwrap.conf << _EOF_
kernel.userns_restrict = 0
_EOF_
%endif

%if %priv_mode == "none"
%post
setcap -q "cap_sys_admin,cap_net_admin,cap_sys_chroot,cap_setuid,cap_setgid=ep" %_bindir/bwrap 2>/dev/null ||:
%endif

%files
%if %priv_mode == "setuid"
%attr(4511,root,root) %_bindir/bwrap
%else
%_bindir/bwrap
%endif
%{?_enable_userns:%_sysctldir/90-bwrap.conf}
%_man1dir/bwrap*
%_datadir/bash-completion/completions/bwrap

%changelog
