# vim: set ft=spec: -*- rpm-spec -*-

# check runs 'bzr selftest' that requires network to success
# export share_network=1 before gear-hsh
%def_without check

# %%branch_switch set %%branch_release use
#%%define branch_switch Mxx

Name: bzr
Version: 2.7.0
Release: %branch_release alt3.bzr20170317

Summary: Bazaar is a decentralized revision control system
License: %gpl2plus
Group: Development/Other

Url: http://bazaar-vcs.org
Packager: Anatoly Kitaykin <cetus@altlinux.ru>

Source: %name-%version.tar

Patch0: %name-%version.patch

%add_python_req_skip launchpadlib
%add_python_req_skip lazr

Conflicts: %name-doc < %version

BuildRequires(pre): rpm-macros-branch
BuildRequires(pre): rpm-build-licenses

# Automatically added by buildreq on Thu Aug 20 2009 (-bi)
BuildRequires: python-module-Pyrex python-modules-compiler python-modules-email python-modules-logging zlib-devel

%{?!__buildreqs:%{?!_without_check:%{?!_without_test:%{?!_disable_check:%{?!_disable_test:BuildRequires: python-module-docutils}}}}}
%{?!__buildreqs:%{?!_without_check:%{?!_without_test:%{?!_disable_check:%{?!_disable_test:BuildRequires: python-module-paramiko}}}}}
%{?!__buildreqs:%{?!_without_check:%{?!_without_test:%{?!_disable_check:%{?!_disable_test:BuildRequires: python-module-testtools}}}}}
%{?!__buildreqs:%{?!_without_check:%{?!_without_test:%{?!_disable_check:%{?!_disable_test:BuildRequires: python-module-python-subunit-tests}}}}}

%description
Bazaar is a distributed version control system that Just Works. While
many similar systems require you to adapt to their model of working,
Bazaar adapts to the workflows you want to use, and it takes only five
minutes to try it out. People have used it to version pretty much
anything: single-file projects, your /etc directory and even the
thousands of files and revisions in the source code for Launchpad,
MySQL and Mailman.

%package -n python-module-bzrlib-tests
Summary: Tools for testing Bazaar
Group: Development/Other

Requires: %name = %version-%release
Provides: bzr-selftest = %version-%release

%description -n python-module-bzrlib-tests
This package contain tools and test suites for testing Bazaar.

%package doc
Summary: %name documentation and examples
Group: Development/Other
BuildArch: noarch

Conflicts: %name < %version

%description doc
Bazaar is a decentralized revision control system. This
package contain documentation and examples for using Bazaar.

%define bzr_docdir %_docdir/%name-%version

%prep
%setup
%patch0 -p1

%build
%add_optflags -fno-strict-aliasing
%python_build

%install
#define _compress_method none
%python_install --install-data=%_datadir
install -dm0755 %buildroot%bzr_docdir
install -m0644 BRANCH.TODO INSTALL NEWS README TODO %buildroot%bzr_docdir
cp -a doc contrib %buildroot%bzr_docdir
# Hack! Need a subst in setup.py
mv %buildroot%_datadir/share/locale %buildroot%_datadir
%find_lang %name

%check
%make_build check

%files -f %name.lang
%_bindir/bzr
%_man1dir/bzr.*
%python_sitelibdir/*
%exclude %python_sitelibdir/bzrlib/tests
%exclude %python_sitelibdir/bzrlib/plugins/*/tests
%exclude %python_sitelibdir/bzrlib/util/tests
%bzr_docdir
%exclude %bzr_docdir/doc
%exclude %bzr_docdir/contrib
#%%_datadir/locale/*/LC_MESSAGES/bzr.mo

%files -n python-module-bzrlib-tests
%dir %python_sitelibdir/bzrlib
%dir %python_sitelibdir/bzrlib/plugins
%dir %python_sitelibdir/bzrlib/plugins/bash_completion
%dir %python_sitelibdir/bzrlib/plugins/changelog_merge
%dir %python_sitelibdir/bzrlib/plugins/grep
%dir %python_sitelibdir/bzrlib/plugins/launchpad
%dir %python_sitelibdir/bzrlib/plugins/netrc_credential_store
%dir %python_sitelibdir/bzrlib/plugins/news_merge
%dir %python_sitelibdir/bzrlib/plugins/po_merge
%dir %python_sitelibdir/bzrlib/plugins/weave_fmt
%dir %python_sitelibdir/bzrlib/util
%python_sitelibdir/bzrlib/tests
%python_sitelibdir/bzrlib/plugins/*/tests
%python_sitelibdir/bzrlib/util/tests
# bash_completion changelog_merge grep launchpad netrc_credential_store news_merge po_merge weave_fmt

%files doc
%dir %bzr_docdir
%bzr_docdir/doc
%bzr_docdir/contrib

%changelog
