
Name: cacti
Version: 1.2.15
Release: alt3

%define cactidir %_datadir/%name
%define cacticonfdir %_sysconfdir/%name
%define username cacti

Summary: The complete RRDTool-based graphing solution.
Summary(ru_RU.UTF8): Полнофункциональная оболочка для RRDTool.

License: GPL
Group: Monitoring

URL: http://www.cacti.net/
Source: %name-%version.tar
Source2: %name-readme.alt
Source3: %name.logrotate
Source5: %name-rrdpath.sql
Source7: %name-apache.conf
Source8: %name-lighttpd.conf

Patch: %name-%version-%release.patch

#The following plugins have been merged into the core Cacti
Provides: cacti-plugin-aggregate = %version-%release
Conflicts: cacti-plugin-aggregate < %version-%release
Provides: cacti-plugin-discovery = %version-%release
Conflicts: cacti-plugin-discovery < %version-%release
Provides: cacti-plugin-settings = %version-%release
Conflicts: cacti-plugin-settings < %version-%release
Provides: cacti-plugin-ssl = %version-%release
Conflicts: cacti-plugin-ssl < %version-%release


Requires: webserver webserver-common rrd-utils net-snmp net-snmp-utils
Requires: php7-snmp php7-sockets php7-pdo php7-pdo_mysql php7-mbstring php7-openssl php7-gd2 php7-gmp

BuildRequires(pre): rpm-macros-webserver-common
BuildArch: noarch
# build docs
BuildRequires: lynx docbook-utils


%description
Cacti is a complete frontend to RRDTool. It stores all of the necessary 
information to create graphs and populate them with data in a MySQL database. 
The frontend is completely PHP driven. Along with being able to maintain graphs, 
data sources, and round robin archives in a database, Cacti also handles the data 
gathering. There is SNMP support for those used to creating traffic graphs with 
MRTG.

%description -l ru_RU.UTF8
Cacti - это полнофункциональная оболочка для RRDTool. Программа хранит всю
необходимую информацию для создания и наполнения графиков в базе MySQL.
Программа полностью написана на PHP. Вместе с возможностью управления
графиками, источниками данных и архивами round robin Cacti также занимается
сбором данных.

%package setup
Summary: Cacti setup package
Group: Monitoring
BuildArch: noarch
Requires: %name = %version-%release

%description setup
Install this package to configure initial Cacti installation. You
should uninstall this package when you're done, as it considered
insecure to keep the setup files in place.

%description -l ru_RU.UTF8 setup
Установите этот пакет для первоначальной инициализации Cacti.
После завершения настройки Cacti Вы должны удалить этот пакет, что бы обеспечить
безопасную работу приложения.

%prep
%setup -q
%patch -p1


%build
chmod a+rx scripts/*
chmod a+rx cli/*

%install -n %name-%version
mkdir -p %buildroot{%_sbindir,%_sysconfdir/cron.d,%cacticonfdir,%cactidir/plugins,%_localstatedir/%name/rra,%_logdir/%name}

cp -a *.php README.md LICENSE %buildroot%cactidir
cp -ar cli formats images include install lib locales mibs plugins resource scripts %buildroot%cactidir
mv -f %buildroot{%cactidir/poller.php,%_sbindir/cacti-poller}
chmod 755 %buildroot%_sbindir/cacti-poller
install -m 0640 include/config.php.dist %buildroot%cacticonfdir/config.php
touch %buildroot%_logdir/%name/%name.log

# you should run this sql if your database contains path to %{_datadir}...
cp %SOURCE5 docs/
cp %SOURCE2 docs/README_ALT.txt
cp %SOURCE7 docs/
cp %SOURCE8 docs/
ln -sf %_docdir/%name-doc-%version %buildroot%cactidir/docs


# install cron
cat << EOF > %buildroot%_sysconfdir/cron.d/cacti
MAILTO=root

*/5 * * * * cacti umask 022; exec /usr/sbin/cacti-poller > /dev/null
EOF

# logrotate
install -D -m 0644 %SOURCE3 %buildroot%_sysconfdir/logrotate.d/cacti

%pre
%_sbindir/useradd -M -d %cactidir -r %username -G %webserver_group > /dev/null 2>&1 ||:
if LANG=C %_bindir/id %username 2>/dev/null | \
grep -qv "groups=[^[:space:]]*(%webserver_group)"; then
echo 'Warning: User %username was not included in the group %webserver_group!'
%_bindir/gpasswd -a %username %webserver_group 
echo '     Added user %username to group %webserver_group.'
fi

%post
%post_service crond

%triggerpostun -- %name < 0.8.7e-alt1
# Migration from previous version
if [ $2 -gt 0 ]; then
echo "Fixing permissions and location rrd,log files after previous package:"
mv -f %_var/www/html/%name/log/* %_logdir/%name/
mv -f %_var/www/html/%name/rra/* %_localstatedir/%name/rra/
chown -v root:%webserver_group  %_logdir/%name/* %_localstatedir/%name/*
chmod -v 660 %_logdir/%name/* %_localstatedir/%name/*
fi

%files
%doc docs/README_ALT.txt docs/%name-rrdpath.sql CHANGELOG LICENSE README.md cacti.sql
%config(noreplace) %_sysconfdir/cron.d/cacti
%_sbindir/cacti-poller
%dir %attr(750,root,%webserver_group) %cacticonfdir
%attr(640,root,%webserver_group) %config(noreplace) %cacticonfdir/config.php
%config(noreplace) %_sysconfdir/logrotate.d/%name
%dir %cactidir
%cactidir/*.php
%cactidir/cli
%cactidir/formats
%cactidir/images
%cactidir/include
%cactidir/lib
%cactidir/locales
%cactidir/mibs
%cactidir/plugins
%cactidir/resource
%dir %cactidir/scripts
%attr(755,root,root) %cactidir/scripts/*

%attr(755,root,%webserver_group) %dir %_localstatedir/%name
%attr(2775,root,%webserver_group) %dir %_localstatedir/%name/rra
%attr(730,root,%webserver_group) %dir %_logdir/%name
%attr(660,root,%webserver_group) %ghost %_logdir/%name/cacti.log

%files setup
%cactidir/install

%changelog
