%define _unpackaged_files_terminate_build 1

Name:    castxml
Version: 0.4.2
Release: alt1
Summary: C-family abstract syntax tree XML output tool
Group:   Development/Other
License: Apache-2.0
URL:     https://github.com/CastXML/CastXML

# https://github.com/CastXML/CastXML.git
Source:	%name-%version.tar

BuildRequires: cmake ctest gcc-c++
BuildRequires: llvm-devel lld
# The llvm cmake files get confused if the static libraries are
# not present even though we don't link against them.
BuildRequires: llvm-devel-static
BuildRequires: clang-devel
# Required clang libraries are built statically at the moment
BuildRequires: clang-devel-static
BuildRequires: libedit-devel
BuildRequires: zlib-devel
BuildRequires: python3-module-sphinx python3-module-sphinx-sphinx-build-symlink
BuildRequires: /proc

Requires: /proc

Obsoletes: gccxml

%description
Parse C-family source files and optionally write a subset of the
Abstract Syntax Tree (AST) to a representation in XML.

Source files are parsed as complete translation units using the clang
compiler. XML output is enabled by the --castxml-gccxml option and
produces a format close to that of gccxml. Future versions of castxml
may support alternative output formats.

%prep
%setup

%build
export CC=clang
export CXX=clang++
%remove_optflags -frecord-gcc-switches

%cmake \
       -DLLVM_LINK_LLVM_DYLIB:BOOL=ON \
       -DCLANG_LINK_CLANG_DYLIB:BOOL=ON \
       -DCastXML_INSTALL_DOC_DIR:STRING=share/doc/%name \
       -DCastXML_INSTALL_MAN_DIR:STRING=share/man \
       -DCLANG_RESOURCE_DIR:PATH=$(clang -print-file-name=include)/.. \
       -DLLVM_LINK_LLVM_DYLIB:BOOL=ON \
       -DBUILD_TESTING:BOOL=ON \
       -DSPHINX_MAN:BOOL=ON \
       -DCMAKE_EXE_LINKER_FLAGS:STRING=-fuse-ld=lld \
       -DLLVM_DIR=$(llvm-config --cmakedir) \
       %nil

%cmake_build

%install
%cmakeinstall_std

rm -f %buildroot%_datadir/doc/%name/LICENSE
rm -f %buildroot%_datadir/doc/%name/NOTICE

%check
pushd BUILD
ctest
popd

%files
%doc LICENSE
%doc NOTICE README.rst
%_bindir/castxml
%_man1dir/castxml.1*
%dir %_datadir/%name
%_datadir/%name/clang
%_datadir/%name/detect_vs.c
%_datadir/%name/detect_vs.cpp
%_datadir/%name/empty.c
%_datadir/%name/empty.cpp

%changelog
