%def_enable  clang
%def_disable shared_libraries
%def_enable  widevine
%def_disable ffmpeg
%def_enable  google_api_keys

%ifndef build_parallel_jobs
%global build_parallel_jobs %__nprocs
%endif

%define is_enabled() %{expand:%%{?_enable_%{1}:true}%%{!?_enable_%{1}:false}}

%global llvm_version 12.0
%global gcc_version %nil
#set_gcc_version %gcc_version

%set_verify_elf_method rpath=relaxed textrel=relaxed lfs=relaxed lint=relaxed

%define _unpackaged_files_terminate_build 1

# Leave this alone, please.
%global target out/Release

# Set up Google API keys, see http://www.chromium.org/developers/how-tos/api-keys .
# Note: these are for ALT Linux use ONLY. For your own distribution,
# please get your own set of keys.
%define api_key               AIzaSyAIIWz7zaCwYcUSe3ZaRPviXjMjkBP4-xY
%define default_client_id     1018394967181.apps.googleusercontent.com
%define default_client_secret h_PrTP1ymJu83YTLyz-E25nP

Name:           chromium
Version:        97.0.4692.99 
Release:        alt0.p9.1

Summary:        An open source web browser developed by Google
License:        BSD-3-Clause and LGPL-2.1+
Group:          Networking/WWW
Url:            https://www.chromium.org

Source0:        chromium.tar.zst

Source30:       master_preferences
Source31:       default_bookmarks.html
Source100:      chromium.sh
Source101:      chromium.desktop
Source102:      chromium.xml
Source200:      chromium.default

Provides:       chromium-browser = %version
Obsoletes:      chromium-browser < %version
Obsoletes:      chromium-stable <= %version

Provides:       webclient

Obsoletes:      chromium-password
Obsoletes:      chromium-kde
Obsoletes:      chromium-gnome
Obsoletes:      chromium-desktop-kde
Obsoletes:      chromium-desktop-gnome

# Unsupported target_cpu
ExcludeArch: ppc64le armh

### Start Patches
Patch001: 0001-OPENSUSE-enables-reading-of-the-master-preference.patch
Patch002: 0002-ALT-Set-appropriate-desktop-file-name-for-default-br.patch
Patch003: 0003-DEBIAN-manpage-fixes.patch
Patch004: 0004-DEBIAN-add-ps-printing-capability-gtk2.patch
Patch005: 0005-ALT-fix-shrank-by-one-character.patch
Patch006: 0006-ALT-Fix-last-commit-position-issue.patch
Patch007: 0007-ALT-Use-rpath-link-and-absolute-rpath.patch
Patch008: 0008-ALT-openh264-always-pic-on-x86.patch
Patch009: 0009-ALT-allow-to-override-clang-through-env-variables.patch
Patch010: 0010-ALT-Hack-to-avoid-build-error-with-clang7.patch
Patch011: 0011-ALT-disable-asm-on-x86-in-dav1d.patch
Patch012: 0012-Move-offending-function-to-chromeos-only.patch
Patch013: 0013-ALT-Do-not-use-no-canonical-prefixes-clang-option.patch
Patch014: 0014-ALT-Disable-NOMERGE-attribute.patch
Patch015: 0015-FEDORA-bootstrap-with-python3.patch
Patch016: 0016-sql-make-VirtualCursor-standard-layout-type.patch
#Patch017: 0017-ALT-fix-build-with-glibc-2.34.patch
### End Patches

BuildRequires: /proc
BuildRequires: /dev/shm

BuildRequires:  bison
BuildRequires:  bzlib-devel
BuildRequires:  flex
BuildRequires:  chrpath
BuildRequires:  libstdc++-devel
BuildRequires:  libstdc++-devel-static
BuildRequires:  glibc-kernheaders
%if_enabled clang
BuildRequires:  clang%{llvm_version}
BuildRequires:  clang%{llvm_version}-devel
BuildRequires:  llvm%{llvm_version}-devel
BuildRequires:  lld%{llvm_version}-devel
%else
BuildRequires:  gcc%gcc_version-c++
%endif
BuildRequires:  ninja-build
BuildRequires:  gperf
BuildRequires:  libcups-devel
BuildRequires:  perl-Switch
BuildRequires:  pkg-config
BuildRequires:  pkgconfig(alsa)
BuildRequires:  pkgconfig(atk)
BuildRequires:  pkgconfig(atk-bridge-2.0)
BuildRequires:  pkgconfig(atspi-2)
BuildRequires:  pkgconfig(cairo) >= 1.6
BuildRequires:  pkgconfig(dbus-1)
BuildRequires:  pkgconfig(dbus-glib-1)
BuildRequires:  pkgconfig(gconf-2.0)
BuildRequires:  pkgconfig(glib-2.0)
BuildRequires:  pkgconfig(gnome-keyring-1)
BuildRequires:  pkgconfig(gtk+-3.0)
%if_enabled ffmpeg
BuildRequires:  pkgconfig(opus)
BuildRequires:  pkgconfig(libavresample)
BuildRequires:  pkgconfig(libavfilter)
BuildRequires:  pkgconfig(libavformat)
BuildRequires:  pkgconfig(libavcodec)
BuildRequires:  pkgconfig(libavutil)
%endif
BuildRequires:  pkgconfig(libcurl)
BuildRequires:  pkgconfig(freetype2)
BuildRequires:  pkgconfig(fontconfig)
BuildRequires:  pkgconfig(expat)
BuildRequires:  pkgconfig(libffi)
BuildRequires:  pkgconfig(libpulse)
BuildRequires:  pkgconfig(libpci)
BuildRequires:  pkgconfig(libva)
BuildRequires:  pkgconfig(krb5-gssapi)
BuildRequires:  pkgconfig(nspr)
BuildRequires:  pkgconfig(nss)
BuildRequires:  pkgconfig(x11)
BuildRequires:  pkgconfig(xcomposite)
BuildRequires:  pkgconfig(xcursor)
BuildRequires:  pkgconfig(xdamage)
BuildRequires:  pkgconfig(xext)
BuildRequires:  pkgconfig(xfixes)
BuildRequires:  pkgconfig(xi)
BuildRequires:  pkgconfig(xtst)
BuildRequires:  pkgconfig(xkbcommon)
BuildRequires:  pkgconfig(xrandr)
BuildRequires:  pkgconfig(xrender)
BuildRequires:  pkgconfig(xscrnsaver)
BuildRequires:  pkgconfig(xt)
BuildRequires:  pkgconfig(xcb-proto)
BuildRequires:  pkgconfig(xshmfence)
BuildRequires:  pkgconfig(libdrm)
BuildRequires:  pkgconfig(gbm)
BuildRequires:  pkgconfig(wayland-client)
BuildRequires:  pkgconfig(wayland-server)
BuildRequires:  pkgconfig(wayland-egl)
BuildRequires:  pkgconfig(wayland-cursor)
BuildRequires:  pkgconfig(wayland-scanner)
BuildRequires:  pkgconfig(dri)
#BuildRequires:  pkgconfig(libpipewire-0.3)
BuildRequires:  pkgconfig(epoxy)
BuildRequires:  node
BuildRequires:  usbids
BuildRequires:  xdg-utils

BuildRequires:  python
BuildRequires:  python-modules-json
BuildRequires:  python3

Requires: libva
Requires: xdg-utils

%description
Chromium is an open-source browser project that aims to build a safer,
faster, and more stable way for all Internet users to experience the web.

%prep
%setup -q -n chromium
%autopatch -p1

sed -i \
	-e '/"-Wno-non-c-typedef-for-linkage"/d' \
	-e 's/"-ffile-compilation-dir=."//g' \
	build/config/compiler/BUILD.gn

mkdir -p third_party/node/linux/node-linux-x64/bin
ln -s %_bindir/node third_party/node/linux/node-linux-x64/bin/node

mkdir -p buildtools/third_party/eu-strip/bin
ln -sf %_bindir/strip buildtools/third_party/eu-strip/bin/eu-strip

rm -f -- third_party/depot_tools/ninja
ln -s %_bindir/ninja third_party/depot_tools/ninja
ln -s %_bindir/python3 third_party/depot_tools/python

%build
%if_enabled clang
export ALTWRAP_LLVM_VERSION="%llvm_version"
export CC="clang"
export CXX="clang++"
export AR="llvm-ar"
export NM="llvm-nm"
export READELF="llvm-readelf"
%else
export CC="gcc"
export CXX="g++"
export AR="ar"
export NM="nm"
export READELF="readelf"
%endif

bits=$(getconf LONG_BIT)

export RANLIB="ranlib"
export PATH="$PWD/third_party/depot_tools:$PATH"
export CHROMIUM_RPATH="%_libdir/%name"

CHROMIUM_GN_DEFINES=
gn_arg() { CHROMIUM_GN_DEFINES="$CHROMIUM_GN_DEFINES $*"; }

gn_arg custom_toolchain=\"//build/toolchain/linux/unbundle:default\"
gn_arg host_toolchain=\"//build/toolchain/linux/unbundle:default\"
gn_arg is_official_build=true
gn_arg use_custom_libcxx=false
gn_arg use_sysroot=false
gn_arg use_gio=true
gn_arg use_glib=true
gn_arg use_libpci=true
gn_arg use_pulseaudio=true
gn_arg use_aura=true
gn_arg use_cups=true
gn_arg use_kerberos=true
gn_arg use_gold=false
gn_arg use_vaapi=true
gn_arg optimize_webui=false
gn_arg use_system_freetype=false
gn_arg use_system_harfbuzz=false
gn_arg link_pulseaudio=true
gn_arg enable_hangout_services_extension=true
gn_arg fieldtrial_testing_like_official_build=true
gn_arg treat_warnings_as_errors=false
gn_arg fatal_linker_warnings=false
gn_arg system_libdir=\"%_lib\"
gn_arg use_allocator=\"none\"
gn_arg use_icf=false
gn_arg enable_js_type_check=false
gn_arg use_system_libwayland=true
gn_arg use_system_wayland_scanner=true
gn_arg use_bundled_weston=false

# ffmpeg
gn_arg ffmpeg_branding=\"Chrome\"
gn_arg proprietary_codecs=true

# Remove debug
gn_arg is_debug=false
gn_arg symbol_level=0

gn_arg enable_nacl=false
gn_arg is_component_ffmpeg=%{is_enabled shared_libraries}
gn_arg is_component_build=%{is_enabled shared_libraries}
gn_arg enable_widevine=%{is_enabled widevine}

gn_arg rtc_use_pipewire=false
gn_arg rtc_link_pipewire=false

%if_enabled clang
gn_arg clang_base_path=\"%_prefix/lib/llvm-%{llvm_version}\"
gn_arg is_clang=true
gn_arg clang_use_chrome_plugins=false
gn_arg use_lld=true
if [ "$bits" = 64 ]; then
%ifarch aarch64
    gn_arg use_thin_lto=false
%else
    gn_arg use_thin_lto=true
%endif
else
    gn_arg use_thin_lto=false
fi
gn_arg is_cfi=false
gn_arg use_cfi_icall=false
gn_arg chrome_pgo_phase=0
%else
gn_arg is_clang=false
%endif

%ifnarch %{ix86} x86_64
gn_arg icu_use_data_file=false
%endif

%ifnarch %{ix86} x86_64 aarch64
gn_arg enable_vulkan=false
%else
gn_arg enable_vulkan=true
%endif

%if_enabled google_api_keys
gn_arg google_api_key=\"%api_key\"
gn_arg google_default_client_id=\"%default_client_id\"
gn_arg google_default_client_secret=\"%default_client_secret\"
%endif

unbundle=
unbundle_lib() { unbundle="$unbundle $*"; }

unbundle_lib fontconfig
unbundle_lib freetype
%if_enabled ffmpeg
unbundle_lib ffmpeg opus
%endif

[ -z "$unbundle" ] ||
	build/linux/unbundle/replace_gn_files.py --system-libraries $unbundle

tools/gn/bootstrap/bootstrap.py --gn-gen-args="$CHROMIUM_GN_DEFINES" --build-path=%target
%target/gn gen --args="$CHROMIUM_GN_DEFINES" %target

n=%build_parallel_jobs
[ "$n" -lt 20 ] || n=20

ninja \
	-vvv \
	-j $n \
	-C %target \
	chrome \
	chrome_sandbox \
	chromedriver \
	policy_templates

%install
mkdir -p -- \
	%buildroot/%_bindir \
	%buildroot/%_man1dir \
	%buildroot/%_libdir/%name \
	%buildroot/%_sysconfdir/%name \
#
install -m 755 %SOURCE100 %buildroot%_bindir/%name
install -m 644 %SOURCE200 %buildroot%_sysconfdir/%name/default

# add directories for policy management
mkdir -p %buildroot%_sysconfdir/%name/policies/managed
mkdir -p %buildroot%_sysconfdir/%name/policies/recommended

# compatibility symlink
ln -s %name %buildroot/%_bindir/chromium-browser

# manpage
.rpm/scripts/make-manpage.sh > %buildroot/%_man1dir/%name.1
ln -s %name.1  %buildroot/%_man1dir/chrome.1

# x86_64 capable systems need this
sed -i -e 's,/usr/lib/chromium,%_libdir/%name,g' %buildroot%_bindir/%name

pushd %target
cp -a chrome           %buildroot%_libdir/%name/%name
cp -a chrome_sandbox   %buildroot%_libdir/%name/chrome-sandbox
cp -a chrome_crashpad_handler %buildroot%_libdir/%name/chrome_crashpad_handler

for chromedriver in chromedriver chromedriver.unstripped; do
	[ ! -x $chromedriver ] || break
done

cp -a $chromedriver %buildroot%_libdir/%name/chromedriver
strip %buildroot%_libdir/%name/chromedriver

ln -s -- %_libdir/%name/chromedriver %buildroot/%_bindir/chromedriver

for f in *.bin *.so* *.pak swiftshader locales icudtl.dat MEIPreload; do
	[ ! -e "$f" ] ||
		cp -at %buildroot%_libdir/%name -- "$f"
done
popd

# Remove garbage
find %buildroot%_libdir/%name -name '*.TOC' -delete
find %buildroot%_libdir/%name/locales -name '*.pak.info' -delete

# Icons
for size in 24 48 64 128 256; do
	install -Dm644 "chrome/app/theme/chromium/product_logo_$size.png" \
		"%buildroot/%_iconsdir/hicolor/${size}x${size}/apps/%name.png"
done
for size in 16 32; do
	install -Dm644 "chrome/app/theme/default_100_percent/chromium/product_logo_$size.png" \
		"%buildroot/%_iconsdir/hicolor/${size}x${size}/apps/%name.png"
done

# Desktop file
install -Dm0644 %SOURCE101 %buildroot/%_desktopdir/%name.desktop

mkdir -p -- %buildroot%_datadir/gnome-control-center/default-apps/
cp -a %SOURCE102 %buildroot%_datadir/gnome-control-center/default-apps/%name.xml

# link to browser plugin path.  Plugin patch doesn't work. Why?
mkdir -p -- %buildroot%_libdir/browser-plugins
ln -s -- %_libdir/browser-plugins %buildroot%_libdir/%name/plugins

# Install the master_preferences file
mkdir -p -- %buildroot%_sysconfdir/%name
install -m 0644 %SOURCE30 %buildroot%_sysconfdir/%name
install -m 0644 %SOURCE31 %buildroot%_sysconfdir/%name

# Set alternative to xbrowser
mkdir -p -- %buildroot%_altdir
cat >%buildroot%_altdir/%name <<EOF
%_bindir/xbrowser	%_bindir/%name	50
%_bindir/x-www-browser	%_bindir/%name	50
EOF

(set +x;
	find %buildroot/%_libdir/%name -type f |
	while read f; do
		t="$(readlink -ev "$f")"

		file "$t" | fgrep -qs ELF || continue

		# Strip Chromium executables to disable debuginfo generation (became too huge)
		#strip -d "$t" ||:

		# Add real RPATH
		chrpath -r '%_libdir/%name' "$t" ||:
	done
)

%files
%doc AUTHORS LICENSE
%dir %_datadir/gnome-control-center
%dir %_datadir/gnome-control-center/default-apps
%dir %_sysconfdir/%name
%dir %_sysconfdir/%name/policies
%dir %_sysconfdir/%name/policies/managed
%dir %_sysconfdir/%name/policies/recommended
%config %_sysconfdir/%name/*
%attr(4711,root,root) %_libdir/%name/chrome-sandbox
%_libdir/%name
%_bindir/*
%_man1dir/*
%_desktopdir/%name.desktop
%_datadir/gnome-control-center/default-apps/*.xml
%_iconsdir/hicolor/*/apps/*.png
%_altdir/%name

%changelog
