Name: composer
Version: 2.0.11
Release: alt1

Summary: Composer helps you declare, manage and install dependencies of PHP projects, ensuring you have the right stack everywhere

License: MIT
Group: System/Configuration/Packaging
Url: https://getcomposer.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/composer/composer/archive/%version.tar.gz
Source: %name-%version.tar
Source1: composer.sh
Source2: composer.sysconfig
Source3: compile
Source4: README.ALT

Source10: %name-production-%version.tar

Patch1: composer-compiler.patch

BuildArch: noarch

BuildRequires: php7

Requires: %_bindir/php
Requires: php7-openssl

%description
Composer helps you declare, manage and install dependencies of PHP projects,
ensuring you have the right stack everywhere.

%prep
%setup -a 10
%patch1 -p2
install %SOURCE3 -D ./compile
cp %SOURCE4 .
%__subst "s|src/Composer/Composer.php|disable-date-changing|" src/Composer/Composer.php

%build

# unused date
# Note! stat -c%%y output is incompatible with date in python!
export RELDATE="$(stat -c '%%y' CHANGELOG.md | sed -e 's|\.[0-9]* | |')"
#build composer.phar
php -d phar.readonly=off -d date.timezone='Europe/Moscow' ./compile %version "$RELDATE"

%install
install -m 0755 -D composer.phar %buildroot/%_datadir/composer.phar
install -m 0755 -D %SOURCE1 %buildroot/%_bindir/%name
install -m 0644 -D %SOURCE2 %buildroot%_sysconfdir/sysconfig/%name

%files
%doc README.ALT
%attr(755,root,root) %_bindir/%name
%attr(755,root,root) %_datadir/%name.phar
%config(noreplace) %_sysconfdir/sysconfig/%name

%changelog
