%define libname libcpufreq

Name: cpufrequtils
Version: 008
Release: alt2

Packager: Victor Forsiuk <force@altlinux.org>

Summary: Tools to determine and set CPUfreq settings
License: GPLv2
Group: System/Base

URL: http://www.kernel.org/pub/linux/utils/kernel/cpufreq/cpufrequtils.html
Source: http://www.kernel.org/pub/linux/utils/kernel/cpufreq/cpufrequtils-%version.tar.bz2

Patch0: 0001-Only-x86-has-cpuid-instruction.patch

Requires: %libname = %version-%release

%description
To make access to the Linux kernel cpufreq subsystem easier for users
and cpufreq userspace tools, the cpufrequtils package was created. It
contains a library used by other programs (libcpufreq), command line
tools to determine current CPUfreq settings and to modify them
(cpufreq-info and cpufreq-set), and debug tools.

%package -n %libname
Summary: Library for %name
License: GPLv2
Group: Development/C

%description -n %libname
This packages contains some library needed by %name.

%package -n %libname-devel
Summary: Headers for developing programs that will use %libname
License: GPLv2
Group: Development/C
Requires: %libname = %version-%release
Obsoletes: %name-devel
Provides: %name-devel

%description -n %libname-devel
This package contains the headers that programmers will need to develop
applications which will use %libname.

%prep
%setup
%patch -p1

subst 's/--mode=/--tag=CC --mode=/' Makefile

%build
%make_build CFLAGS="%optflags" V=true

%install
%makeinstall_std mandir=%_mandir libdir=%_libdir V=true

%find_lang cpufrequtils

%files -f cpufrequtils.lang
%_bindir/*
%_man1dir/*

%files -n %libname
%_libdir/libcpufreq.so.*

%files -n %libname-devel
%_includedir/*
%_libdir/libcpufreq.so

%changelog
