Name:     cutecom
Version:  0.51.0
Release:  alt2

Summary:  A graphical serial terminal
Summary(pl): Graficzny terminal szeregowy
Summary(ru_RU.UTF-8): Графический последовательный терминал
License:  GPL-3.0+
Group:    Communications
Url:      https://gitlab.com/cutecom/cutecom

Source:   %name-%version.tar
Patch:    cutecom-0.40.0-mga-fixinstall.patch

# Upstream patch
Patch1:   0001-Fix-build-with-Qt-5.15-hopefully.patch 

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake gcc-c++
BuildRequires: desktop-file-utils
BuildRequires: pkgconfig(Qt5Core)
BuildRequires: pkgconfig(Qt5Gui)
BuildRequires: pkgconfig(Qt5SerialPort)
BuildRequires: pkgconfig(Qt5Widgets)
# build MarkDown
BuildRequires: pandoc

# Required for xmodem support
Requires: lrzsz

%description
Cutecom is a graphical serial terminal, like minicom. It is aimed
mainly at hardware developers or other people who need a terminal to
talk to their devices.

%description -l ru_RU.UTF-8
Cutecom - графический последовательный терминал, похожий на minicom.
В основном он предназначен для разработчиков электронной аппаратуры
и для тех, кому нужен терминал для передачи команд устройствам.
Среди его особенностей: строчный интерфейс (в отличие от символьного),
поддержка xmodem, ymodem и zmodem (требуется пакет lrzsz),
шестнадцатеричный ввод/вывод и др.  Cutecom написан с использованием
библиотеки Qt.

%prep
%setup
%patch -p1
%patch1 -p1

%build
%cmake
%cmake_build

%install
%cmakeinstall_std

# Upstream script does not install the .desktop file if KDE is not installed,
# so we install it manually
mkdir -p %buildroot%_desktopdir
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-key=Path --remove-key=Encoding \
	--remove-category=Utility \
	--add-category=System \
	cutecom.desktop

pandoc -f markdown -t html README.md -o README.html

%files
%doc Changelog LICENSE README.html *.png TODO
%_bindir/*
%_man1dir/*
%_desktopdir/*
%_iconsdir/hicolor/scalable/apps/cutecom.svg

%changelog
