%define ver_major 3.4
%define beta %nil
%def_enable noise_tools
%def_disable libavif

Name: darktable
Version: %ver_major.1
Release: alt1

Summary: Darktable is a virtual lighttable and darkroom for photographer
License: GPL-3.0
Group: Graphics
Url: http://%name.org/

Vcs: https://github.com/darktable-org/darktable.git
Source: https://github.com/darktable-org/darktable/releases/download/release-%version/%name-%version.tar.xz
# required for llvm-7.0
Patch: darktable-3.0.0-is_supported_platform.patch
#See https://bugzilla.altlinux.org/38215
# based on https://bugzilla.altlinux.org/attachment.cgi?id=8682&action=edit
# by Pavel Nakonechnyi
Patch1: darktable-3.4.0-alt-disable-use-of-gcc-graphite.patch

ExcludeArch: %ix86 armh

%define cmake_ver 3.10
%define openmp_ver 4.0
%define glib_ver 2.40
%define gtk_ver 3.22
%define exiv2_ver 0.24
%define iso_codes_ver 3.66
%define pugixml_ver 1.8
%define libavif_ver 0.8.2

Requires: iso-codes >= %iso_codes_ver
Requires: icon-theme-adwaita

BuildRequires(pre):rpm-macros-cmake
BuildRequires: /proc cmake >= %cmake_ver gcc-c++ libgomp-devel
BuildRequires: intltool desktop-file-utils libappstream-glib-devel po4a
BuildRequires: perl-Pod-Parser xsltproc exiftool
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver libxml2-devel
BuildRequires: libSDL2-devel libX11-devel libXrandr-devel libcurl-devel
BuildRequires: libexiv2-devel >= %exiv2_ver libflickcurl-devel libsecret-devel
BuildRequires: libgphoto2-devel libjpeg-devel liblcms2-devel liblensfun-devel
BuildRequires: libpng-devel librsvg-devel libsqlite3-devel libtiff-devel
BuildRequires: openexr-devel libxkbcommon-x11-devel lsb-release
BuildRequires: libjson-glib-devel libsoup-devel libpixman-devel libexpat-devel
BuildRequires: libcolord-gtk-devel libudev-devel
BuildRequires: libGraphicsMagick-c++-devel libopenjpeg2.0-devel
BuildRequires: libharfbuzz-devel libwebp-devel libxshmfence-devel
# since 2.0
BuildRequires: libpugixml-devel >= %pugixml_ver libcups-devel
BuildRequires: libosm-gps-map1.0-devel
BuildRequires: python-module-jsonschema
BuildRequires: iso-codes-devel >= %iso_codes_ver
BuildRequires: libgmic-devel
# since 3.2.0
%{?_enable_libavif:BuildRequires: libavif-devel >= %libavif_ver}
# for not recommended build from git tree
#BuildRequires: gnome-doc-utils fop saxon ...

%description
darktable is a virtual light table and darkroom for photographers. It manages
your digital negatives in a database and lets you view them through a zoomable
light table. It also enables you to develop raw images and enhance them.

%prep
%setup -n %name-%version
%patch1 -p1

%build
%define _optlevel 3
%cmake \
-DCMAKE_SKIP_RPATH:BOOL=OFF \
-DCMAKE_BUILD_TYPE=Release \
-DBINARY_PACKAGE_BUILD:BOOL=ON \
-DRAWSPEED_ENABLE_LTO=ON \
%{?_enable noise_tools:-DBUILD_NOISE_TOOLS=ON} \
%ifarch ppc64le
-DUSE_OPENCL=OFF
%endif
%nil
%cmake_build

%install
%cmakeinstall_std

ln -s %name/lib%name.so %buildroot%_libdir/lib%name.so

install -pD -m644 data/pixmaps/16x16/darktable.png %buildroot%_miconsdir/darktable.png
install -pD -m644 data/pixmaps/32x32/darktable.png %buildroot%_niconsdir/darktable.png
install -pD -m644 data/pixmaps/48x48/darktable.png %buildroot%_liconsdir/darktable.png

%find_lang --with-man --all-name --output=%name.lang %name

%files -f %name.lang
%_bindir/*
%_datadir/%name/
%_libdir/lib%name.so
%_libdir/%name/
%_desktopdir/*
%_iconsdir/hicolor/*/apps/*
%_man1dir/*
%_datadir/appdata/%name.appdata.xml
%{?_enable noise_tools:
%_libexecdir/%name/tools/%name-gen-noiseprofile
%_libexecdir/%name/tools/%name-noiseprofile
%_libexecdir/%name/tools/profiling-shot.xmp
%_libexecdir/%name/tools/subr.sh}
%exclude /usr/share/doc/%name/

%changelog
