%def_with beesu
%def_without applet
%def_disable static
%def_enable doc
%define ddcreleasedate 20140603git9d89d8c

Name: ddccontrol
Version: 0.4.2
Release: alt17.%ddcreleasedate

Summary: Control your monitor by software using the DDC/CI protocol
License: GPLv2+
Group: System/Configuration/Hardware

URL: http://ddccontrol.sourceforge.net/
Source0: http://dl.sf.net/ddccontrol/ddccontrol-%version-%ddcreleasedate.tar
Patch1: ddccontrol-0.4.2-fixasneeded.patch
Patch2: ddccontrol-0.4.2-desktop-alt11.patch
Patch3: ddccontrol-0.4.2-alt-fix-linkage.patch
Patch5: ddccontrol-0.4.2-russian.patch
Patch6: ddccontrol-autopoint.patch

# Automatically added by buildreq on Thu Oct 21 2010
BuildRequires: intltool libICE-devel libpci-devel libxml2-devel libgtk+2-devel
%if_with applet
BuildRequires: libgnome-panel-devel libgtk+3-devel
%endif
%if_enabled doc
BuildRequires: xsltproc docbook-style-xsl tidy
%endif

Requires: ddccontrol-db
Requires: lib%{name} = %version-%release
# gddccontrol .destkop
%if_with beesu
Requires: beesu
%else
Requires: xdg-utils
%endif

%description
DDCcontrol is a program used to control monitor parameters, like brightness and
contrast, by software, i.e. without using the OSD (On Screen Display) and the
buttons in front of the monitor.

%package -n lib%{name}
Summary: Libddccontrol library 
Group: Development/Other

%description -n lib%{name}
DDCcontrol is a program used to control monitor parameters, like brightness and
contrast, by software, i.e. without using the OSD and the buttons in front of
the monitor.

%package -n lib%{name}-devel
Summary: Libddccontrol library headers and development libraries
Group: Development/Other
Requires: lib%{name} = %version-%release

%description -n lib%{name}-devel
libddccontrol devel files

%package -n gddccontrol
Summary: GUI for controlling your monitor using the DDC/CI protocol
Group: System/Configuration/Hardware
Requires: %name = %version-%release

%description -n gddccontrol
DDCcontrol is a program used to control monitor parameters, like brightness and
contrast, by software, i.e. without using the OSD and the buttons in front of
the monitor.

gddccontrol is a GUI for ddccontrol.

%package applet
Summary: GNOME applet for ddccontrol
Group: Graphical desktop/GNOME
Requires: %name = %version-%release

%description applet
GNOME applet for ddccontrol.

%prep
%setup
#patch1 -p1
%patch2 -p1
%patch3 -p1
%patch5 -p1
%patch6 -p1 -b .autopoint

%build
#autoreconf
touch config.rpath
./autogen.sh
%configure %{subst_enable static} %{subst_enable doc}
# safety belts :)
echo "#define HAVE_BUGGY_I2C_DEV 1" >>src/config.h
%make_build

%install
%makeinstall_std

rm -rf %buildroot%_datadir/doc/%name

%if_with beesu
sed -i -e s,xdg-su,beesu, %buildroot/%_desktopdir/*.desktop
%endif

%find_lang %name

%files -f %name.lang
%doc AUTHORS NEWS doc/html
%_bindir/ddccontrol
%_bindir/ddcpci
%_man1dir/%{name}*

%files -n gddccontrol
%_bindir/gddccontrol
%_man1dir/g%{name}*
%_desktopdir/*
%_liconsdir/*
%_iconsdir/Bluecurve/48x48/apps/gddccontrol.png

%files -n lib%{name}
%_libdir/*.so.*

%files -n lib%{name}-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc

%if_with applet
%files applet
%dir %_libdir/ddccontrol
%_libdir/ddccontrol/ddcc-applet
%_datadir/ddccontrol
%_libdir/bonobo/servers/*
%endif

%changelog
