%define ver_major 3.32
%define api_ver 3.0
%define xdg_name org.gnome.Devhelp

Name: devhelp
Version: %ver_major.0
Release: alt1

Summary: Developer's help program
Group: Development/Other
License: %gpl3plus
Url: https://wiki.gnome.org/Apps/Devhelp

# VCS: git://git.gnome.org/devhelp
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

%define gtk_ver 3.22.0

Requires: lib%name = %version-%release

BuildRequires(pre): meson rpm-build-gnome rpm-build-licenses
BuildRequires: gtk-doc yelp-tools libappstream-glib-devel
BuildRequires: pkgconfig(gtk+-3.0) >= 3.19.3
BuildRequires: pkgconfig(webkit2gtk-4.0) >= 2.19.2
BuildRequires: pkgconfig(gio-2.0) >= 2.40
BuildRequires: pkgconfig(amtk-5)
BuildRequires: zlib-devel
# since 3.23.x
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel libwebkit2gtk-gir-devel
BuildRequires: gsettings-desktop-schemas-devel

%description
A developers help program.

%package -n lib%name
Summary: Devhelp widgets library
Group: System/Libraries

%description -n lib%name
This package provides shared library required for Devhelp to work.

%package -n lib%name-devel
Summary: Devhelp widgets headers
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package provides files required to develop programs that use
Devhelp widgets.

%package -n lib%name-gir
Summary: GObject introspection data for the Devhelp library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
This package provides GObject introspection data for the Devhelp
library.

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Devhelp library
Group: Development/Other
BuildArch: noarch
Requires: lib%name-gir = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-gir-devel
This package provides GObject introspection devel data for the Devhelp
library.

%package -n lib%name-devel-doc
Summary: Development documentation for Devhelp library
Group: Development/Documentation
BuildArch: noarch
Conflicts: lib%name-devel < %version

%description -n lib%name-devel-doc
This package provides development documentation for the Devhelp library.

%package -n gedit-plugin-%name
Summary: DevHelp integration into GEdit
Group: Development/Other
Requires: %name = %version-%release

%description -n gedit-plugin-%name
This plugin for GEdit enables using DevHelp from inside the editor.

%define _devhelpdir %_datadir/%name
%define  gedit_pluginsdir %_libdir/gedit/plugins

%prep
%setup

%build
%meson -Dgtk_doc=true

%meson_build

%install
%meson_install

# Create some directories in %name hierarchy
mkdir -p %buildroot%_devhelpdir/{specs,books}

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%dir %_devhelpdir
%_devhelpdir/*
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/*/%{xdg_name}*.svg
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/glib-2.0/schemas/org.gnome.devhelp.gschema.xml
%_man1dir/%name.1.*
%_datadir/metainfo/%xdg_name.appdata.xml
%doc AUTHORS NEWS README

%files -n lib%name
%_libdir/*.so.*
%_datadir/glib-2.0/schemas/org.gnome.libdevhelp-3.gschema.xml

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/lib%name-*.pc

%files -n lib%name-gir
%_typelibdir/Devhelp-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/Devhelp-%api_ver.gir

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/%name-*/

%files -n gedit-plugin-%name
%gedit_pluginsdir/*

%changelog
