# TODO: drop bundled lzo, popt

Name: distcc
Version: 3.4
Release: alt6

Summary: distcc is a program to distribute builds C/C++/ Objective C/C++

License: GPLv2
Group: Development/Tools
Url: http://distcc.org

# Source-url: https://github.com/distcc/distcc/archive/v%version.tar.gz
Source: %name-%version.tar
Source1: distccd.init
Source2: distccd.conf
Source3: distcc.filetrigger

BuildRequires: binutils-devel
BuildRequires: libavahi-devel libpopt-devel
BuildRequires: python3-devel
BuildRequires(pre): rpm-build-python3 rpm-build-intro

%add_python3_req_skip distcc_pump_c_extensions

%description
distcc is a program to distribute builds of C, C++, Objective C
or Objective C++ code across several machines on a network.
distcc should always generate the same results as a local build,
is simple to install and use, and is often two or more
times faster than a local compile.

%package    server
Summary:    Server for distributed C/C++ compilation
Group:      Development/Tools
License:    GPLv2+

Requires:   %name = %EVR
Obsoletes: %name < 3.1

%description server
This package contains the compilation server needed to use %{name}.

%package    pump
Summary:    Include server for distributed C/C++ compilation
Group:      Development/Tools
License:    GPLv2+
Requires:   python3-module-include_server = %EVR
Requires:   %name = %EVR

%description pump
This package contains the include server for use %{name}.

%package -n python3-module-include_server
Summary: distcc include_server for Python 3
Group: Development/Python

%description -n python3-module-include_server
Python3 module distcc include_server.

%prep
%setup

%build
# FIXME: autoreconf in hasher missed CC= in Makefile
#autoreconf
./autogen.sh
%configure --disable-Werror
%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_sysconfigdir/ %buildroot%_initdir/
mkdir -p -m755 %buildroot%prefix/lib/distcc
mkdir -p -m755 %buildroot%prefix/lib/rpm
install -p -m 0755 %SOURCE1  %buildroot%_initdir/distccd
install -p -m 0644 %SOURCE2 %buildroot%_sysconfigdir/distccd
install -p -m 0755 %SOURCE3 %buildroot%prefix/lib/rpm

mkdir -p %buildroot%_sysconfdir/buildreqs/packages/ignore.d/
touch %buildroot%_sysconfdir/buildreqs/packages/ignore.d/distcc

rm -rf %buildroot/etc/default/
rm -rf %buildroot/%_docdir/

%preun
# 0 means "last" unininstall
[ "$1" -ne 0 ] || find /usr/lib/distcc -type l -delete ||:

%pre server
%groupadd distccd || :
%useradd -g distccd -d /dev/null -c "distccd user" distccd || :

%post server
%post_service distccd

%preun server
%preun_service distccd

%files
%doc AUTHORS NEWS README README.pump TODO
%_bindir/distcc
%_bindir/lsdistcc
%_bindir/distccmon-text
%_sbindir/update-distcc-symlinks
%_man1dir/distcc.*
%_man1dir/lsdistcc.*
%_man1dir/distccmon-text.*
%_sysconfdir/buildreqs/packages/ignore.d/distcc
%dir %_sysconfdir/distcc/
%_sysconfdir/distcc/hosts
%prefix/lib/rpm/distcc.filetrigger
# XXX: don't change this to %_lib, please!
%dir %prefix/lib/distcc

%files pump
%_bindir/pump
%_man1dir/include_server*
%_man1dir/pump*

%files server
%doc doc/*.txt
%_initdir/distccd
%config(noreplace) %_sysconfigdir/distccd
%_bindir/distccd
%_man1dir/distccd.*
%_sysconfdir/distcc/*allow*

%files -n python3-module-include_server
%python3_sitelibdir/include_server*

%changelog
