%define docbook_man %_datadir/xml/docbook/xsl-stylesheets/manpages/docbook.xsl

Name: dosbox
Epoch: 1
Version: 0.74.2
Release: alt1

Summary: i8086/DOS/VGA software emulator for running old games
Summary(ru_RU.UTF8): Программный эмулятор i8086/DOS/VGA для запуска старых игр

License: GPLv2+
Group: Emulators

Url: http://dosbox.com

Packager: Anton Chernyshov <ach@altlinux.org>

Source0: %name-%version.tar.gz
Source1: DOSBox-russian-lang.zip

# additional scripts and man
Source2: %name-wrapper
Source3: %name-install
Source4: %name-install.xml

# icons and desktop file
Source5: %name.xpm
Source6: %name.desktop

# fix #24306 bug
Source7: %name-0.74-2.conf
Source8: README_ru.ALT

Patch: fix_werror_return_type.patch

Requires: shadow-utils unarj unzip unrar

Conflicts: dosbox-russian

BuildPreReq: docbook-dtds
BuildPreReq: docbook-style-xsl
BuildPreReq: gcc-c++
BuildPreReq: libalsa-devel
BuildPreReq: libGL-devel
BuildPreReq: libGLU-devel
BuildPreReq: libpng-devel
BuildPreReq: libSDL-devel
BuildPreReq: libSDL_net-devel
BuildPreReq: libSDL_sound-devel
BuildPreReq: libX11-devel
BuildPreReq: xsltproc
BuildPreReq: unzip

# Automatically added by buildreq on Sat Jul 12 2014
# optimized out: gnu-config libGL-devel libGLU-devel libSDL-devel libX11-devel libcloog-isl4 libstdc++-devel libtinfo-devel xorg-kbproto-devel xorg-xproto-devel zlib-devel
BuildRequires: gcc-c++ libSDL_net-devel libSDL_sound-devel libalsa-devel libncurses-devel libpng-devel

%description
DOSBox is graphical application that provides rich programming emulation
of Intel 8086 real-mode, SVGA and DOS with XMS/EMS (but no DPMI!).

This is very useful for running old good DOS games written for PC/XT/AT
that's impossible directly on modern Pentiums, SUN's, PowerPC & etc.
At least PII 400MHz is required for comfortable running.

Full list of tested games successfully supported by DOSBox
is published on the http://dosbox.sourceforge.net site.

Run it as following:
  * dosbox /path/to/game.exe
  * dosbox /path/to/gamedir
Examples:
  * dosbox /tmp/old-games/ugh.exe
    ...maps given directory to drive C: and start given EXE/COM/BAT-file
  * dosbox /usr/local/games
    ...maps given directory to drive C: and start built-in COMMAND.COM

%description -l ru_RU.UTF8
DOSBox - это графическое приложение, программно эмулирующее
процессор Intel 8086, графический адаптер SVGA
и операционную систему DOS с поддержкой XMS и EMS, но без DPMI.

DOSBox позволяет запускать на современном компьютере старые игры,
созданные для XT и AT, и не работающие на более новых системах.
Для комфортной работы требуется PII 400MHz или сравнимый с ним
по скорости процессор любой архитектуры (SUN, PowerPC и т.д.).

Полный список протестированных игр (Tower, Wings of Fury, Dune, ...)
находится на официальном сайте программы: http://dosbox.sourceforge.net.

Запуск эмулятора производится следующим образом:
  * dosbox /путь/к/игре/game.exe
  * dosbox /путь/к/игре
Примеры:
  * dosbox /tmp/old-games/ugh.exe
    ...отобразит каталог игры на диск C: и запустит указанный EXE/COM/BAT-файл
  * dosbox /usr/local/games
    ...отобразит указанный каталог на диск C: и запустит встроенный COMMAND.COM

%prep
%setup
%patch -p2

# Create script dosbox-set-lang (#24306)

cat > %name-set-lang << EOF
#!/bin/bash
#
# This script is distributed under terms of GPLv2 or later
# Copyright (C) Anton Chernyshov <ach@altlinux.org>
#
# Encoding in this file is UTF-8
#
# This is a simple script that set default DOSBox language
# to English or Russian language.
# It requires setting one parameter: en or ru,
# which would set needed language.
#
# Это простой скрипт, переключающий используемый DOSBox
# язык на указанный пользователем.
# Скрипту необходимо указать один параметр: en или ru,
# который и установит нужный язык.
#

if [ -e ~/.%name/%name-%version.conf ]; then
	echo "File exist. GOOD!";
else
	echo "File doesn't exist. Creating!"
	cp %_defaultdocdir/%name-%version/%name-%version.conf ~/.%name/
fi

case \$1 in
ru)
    echo "Set DOSBox language to Russian"
    sed -i -e 's/^language=$/language=\/usr\/share\/doc\/%name-%version\/DOSBox-russian-lang\/russian.txt/' \
	   -e 's/^keyboardlayout=auto/keyboardlayout=RU/' \
	~/.%name/%name-%version.conf
	;;
en)
    echo "Set DOSBox language to English"
    sed -i -e 's/language=\/usr\/share\/doc\/%name-%version\/DOSBox-russian-lang\/russian.txt/language=/' \
	   -e 's/^keyboardlayout=RU/keyboardlayout=auto/' \
	~/.%name/%name-%version.conf
	;;
*)
    echo "Please set correct options: en or ru";
esac
EOF

%build
%configure \
	--enable-debug=heavy \
	--enable-core-inline \
	--disable-fpu-x86

%make_build
cp -a src/dosbox src/dosbox-debug

make distclean
%configure \
	--enable-core-inline \
	--disable-fpu-x86

%make_build
xsltproc %docbook_man %{SOURCE4}

%install
%makeinstall_std

# install dosbox debugger
install src/%name-debug %buildroot%_bindir/%name-debug

# install additional scripts
install -D -p %{SOURCE2} %buildroot/%_bindir/%name-install
install -D -p %{SOURCE3} %buildroot/%_bindir/%name-wrapper

# install dosbox-install manual
install -D dosbox-install.1 %buildroot/%_man1dir/dosbox-install.1

# install DOSBox-russian-docs
mkdir -p %buildroot/%_defaultdocdir/%name-%version/
unzip %{SOURCE1} -d %buildroot/%_defaultdocdir/%name-%version/

# install upstream docs
cp AUTHORS ChangeLog NEWS README THANKS %buildroot/%_defaultdocdir/%name-%version
cp docs/{README.video,PORTING} %buildroot/%_defaultdocdir/%name-%version

# create directory for data files and for placing games
mkdir -p %buildroot{%_datadir/%name,%_gamesbindir/%name}

# install icons and desktop file
install -D -m 0644 %{SOURCE5} %buildroot/%_iconsdir/%name.xpm
install -D -m 0644 %{SOURCE6} %buildroot/%_desktopdir/%name.desktop

# fix #24306 bug
install -D -m755 %name-set-lang %buildroot%_bindir/%name-set-lang
cp %{SOURCE7} %{SOURCE8} %buildroot/%_defaultdocdir/%name-%version

%files
%_bindir/*
%dir %_datadir/%name
%_man1dir/%{name}*
%doc %_defaultdocdir/*
%_iconsdir/*
%_desktopdir/*

%changelog
