%define _libexecdir /usr/libexec
%define _ssldir %(openssl-config --openssldir)
%define _unpackaged_files_terminate_build 1

%def_disable debug

Name: dovecot
Version: 2.3.16
Release: alt1

Summary: Dovecot secure IMAP/POP3 server
License: MIT
Group: System/Servers

Url: http://www.dovecot.org/

# Repacked https://dovecot.org/releases/2.3/dovecot-%version.tar.gz
Source0: %name-%version.tar
Source1: dovecot.pam
Source2: dovecot.init
# XXX doesn't work for now
Source3: dovecot-auth.control
Source4: http://www.unicode.org/Public/UNIDATA/UnicodeData.txt
Source5: %name.watch

Patch1: fix-mail_plugin_dir-default.patch
Patch2: dovecot-2.0-defaultconfig.patch
#Patch3: dovecot-2.1-privatetmp.patch
Patch4: dovecot-2.1.4-postreleasefix.patch
Patch5: dovecot-2.3-systemd_firsttime.patch

Requires(pre,postun): mailboxes-control

# TODO remove this when splitting into modules
%add_findreq_skiplist %_libexecdir/dovecot/decode2text.sh

BuildRequires: bzlib-devel
BuildRequires: gcc-c++
BuildRequires: libkrb5-devel
BuildRequires: libldap-devel
BuildRequires: libmysqlclient-devel
BuildRequires: libpam-devel
BuildRequires: libsasl2-devel
BuildRequires: libsqlite3-devel
BuildRequires: libssl-devel
BuildRequires: libsystemd-devel
BuildRequires: openssl
BuildRequires: postgresql-devel
BuildRequires: zlib-devel

Obsoletes: dovecot1.0
Obsoletes: dovecot1.2

%description
Dovecot is an IMAP/POP3 server for Linux/UNIX-like systems, written with
security primarily in mind. Although it's written with C, it uses
several coding techniques to avoid most of the common pitfalls.

Dovecot can work with standard mbox and maildir formats and it's fully
compatible with UW-IMAP and Courier IMAP servers as well as mail clients
accessing the mailboxes directly.

%package -n %name-devel
Summary: Libraries and headers for Dovecot
Group: Development/Other

Requires: %name = %version-%release
Obsoletes: dovecot1.0-devel
Obsoletes: dovecot1.2-devel

%description -n %name-devel
Libraries and headers for Dovecot

%prep
%setup

%patch1 -p1
%patch2 -p1
#patch3 -p1
%patch4 -p1
%patch5 -p2

sed -i 's@/usr/local@/usr@g' src/plugins/fts/decode2text.sh
sed -i 's@/usr/local@/usr@g' doc/example-config/conf.d/90-quota.conf

%ifarch %e2k
# lcc 1.23.12 won't do that
sed -i 's, ATTR_RETURNS_NONNULL,,' src/lib/mempool.h
%endif

xz -9 ChangeLog

%build
%undefine _configure_gettext
%add_optflags -D_DEFAULT_SOURCE=1
export ACLOCAL='aclocal -I .'
%autoreconf
%configure \
	    --localstatedir=%_var                   \
	    --with-moduledir=%_libdir/%name/modules \
	    --disable-static                        \
	    --with-ssl=openssl                      \
	    --with-ssldir=%_ssldir                  \
	    --with-pgsql                            \
	    --with-mysql                            \
	    --with-sqlite                           \
	    --with-ldap                             \
	    --with-gssapi                           \
	    #

# setup right ssl directory
sed -i 's|/etc/ssl|%_ssldir|' doc/mkcert.sh doc/example-config/conf.d/10-ssl.conf

cp -a %SOURCE4 src/lib
%make_build

%install
%makeinstall_std

install -Dp -m 0600 %SOURCE1 %buildroot%_sysconfdir/pam.d/dovecot
install -Dp -m 0755 %SOURCE2 %buildroot%_initdir/%name

# generate ghost .pem files
touch empty
install -Dp -m600 empty %buildroot%_ssldir/certs/dovecot.pem
install -Dp -m600 empty %buildroot%_ssldir/private/dovecot.pem

mkdir -p %buildroot/run/dovecot/{login,empty}
chmod 755 %buildroot/run/dovecot
chmod 700 %buildroot/run/dovecot/login
mkdir -p %buildroot/var/cache/dovecot/indexes

# Install dovecot configuration and dovecot-openssl.cnf
mkdir -p %buildroot%_sysconfdir/dovecot/conf.d
install -Dp -m 644 doc/example-config/dovecot.conf %buildroot%_sysconfdir/dovecot
install -p -m 644 doc/example-config/conf.d/*.conf %buildroot%_sysconfdir/dovecot/conf.d
install -p -m 644 doc/example-config/conf.d/*.conf.ext %buildroot%_sysconfdir/dovecot/conf.d
install -Dp -m 644 doc/dovecot-openssl.cnf %buildroot%_ssldir/dovecot-openssl.cnf

install -Dp -m755 doc/mkcert.sh %buildroot%_libexecdir/%name/mkcert.sh

mkdir -p %buildroot%_localstatedir/%name

# remove the libtool archives
find %buildroot%_libdir/%name/ -name '*.la' | xargs rm -f

# remove what we don't want
rm -f %buildroot%_sysconfdir/dovecot/README
rm -f %buildroot%_bindir/dovecot-sysreport
rm -f %buildroot%_man1dir/dovecot-sysreport.1*

# hi buildreq!
( cd %buildroot%_libdir; ln -s %name/lib*.so.* . )

# create tmpfiles.conf
mkdir -p %buildroot%_tmpfilesdir
cat >%buildroot%_tmpfilesdir/%name.conf<<END
d /run/dovecot 0755 root root -
d /run/dovecot/empty 0750 root root -
d /run/dovecot/login 0700 root root -
END

%pre
%pre_control mailboxes
groupadd -r -f dovecot 2>/dev/null ||:
useradd -r -n -g dovecot -c 'Dovecot internal processes' \
		-d %_var/run/%name -s /dev/null dovecot 2>/dev/null ||:
groupadd -r -f dovenull 2>/dev/null ||:
useradd -r -n -g dovenull -c 'Dovecot untrusted login processes' \
		-d %_var/run/%name -s /dev/null dovenull 2>/dev/null ||:
%post
%post_control -s private mailboxes
%post_service %name

# TODO postun old mailboxes access?

%files
%doc AUTHORS ChangeLog* COPYING NEWS README
%_bindir/doveconf
%_bindir/doveadm
%_bindir/dsync
%_sbindir/dovecot
%dir %_datadir/dovecot
%_datadir/dovecot/*
%_unitdir/*

%dir %_cachedir/dovecot
%dir %_cachedir/dovecot/indexes
%dir %_localstatedir/dovecot

%_tmpfilesdir/%name.conf

%_initdir/dovecot

%dir %_sysconfdir/dovecot
%dir %_sysconfdir/dovecot/conf.d
%config(noreplace) %_sysconfdir/dovecot/dovecot.conf
%config(noreplace) %_sysconfdir/dovecot/conf.d/*
%config(noreplace) %_sysconfdir/pam.d/dovecot
%config(noreplace) %_ssldir/dovecot-openssl.cnf
%attr(0600,root,root) %ghost %config(missingok,noreplace) %verify(not md5 size mtime) %_ssldir/certs/dovecot.pem
%attr(0600,root,root) %ghost %config(missingok,noreplace) %verify(not md5 size mtime) %_ssldir/private/dovecot.pem

%_libexecdir/dovecot

%_docdir/dovecot

%_man1dir/*
%_man7dir/doveadm-search-query.*

# hi buildreq
%_libdir/lib*.so.*
%_libdir/dovecot
%exclude %_libdir/dovecot/libdovecot*.so
%exclude %_libdir/dovecot/dovecot-config

%files -n %name-devel
%_includedir/dovecot
%_datadir/aclocal/dovecot.m4
%_libdir/dovecot/libdovecot*.so
%_libdir/dovecot/dovecot-config

%changelog
