%def_disable qt4
%define oname eigen
Name: %{oname}3
Version: 3.3.7
Release: alt4
Summary: C++ template library for linear algebra
License: LGPLv3+ or GPLv2+
Group: Development/C++
Url: http://eigen.tuxfamily.org/
Packager: Andrey Cherepanov <cas@altlinux.org>

Source: %name-%version.tar

# Install FindEigen3.cmake
# Adapted from Debian eigen3 package
Patch0:         01_install_FindEigen3.patch
# Fix pkg-config file
Patch1:         eigen_pkgconfig.patch
# Fix the include paths in the new Eigen3Config.cmake file
Patch2:         eigen3-3.3.1-fixcmake.patch
# Avoid SSE4.2/AVX on e2k
Patch3:		eigen3-3.3.7-alt-e2k.patch

%ifnarch %e2k
BuildRequires: libsuitesparse-devel libscotch-devel libgoogle-sparsehash
%endif
BuildRequires: gcc-c++ cmake doxygen
%if_enabled qt4
BuildRequires: libqt4-devel
%endif
BuildRequires: libsuperlu-devel libmpfr-devel libgmp-devel
BuildRequires: libfftw3-devel libGLU-devel libgsl-devel gcc-fortran
BuildRequires: liblapack-devel libglew-devel libGLUT-devel libXi-devel
BuildRequires: libXmu-devel libmetis-devel phonon-devel libXres-devel
BuildRequires: libXcomposite-devel libXdamage-devel libXdmcp-devel
BuildRequires: libXft-devel libxkbfile-devel libXpm-devel
BuildRequires: libXScrnSaver-devel libXxf86misc-devel libXxf86vm-devel

# TODO: add devel subpackage and move stuff
Provides: %{name}-devel = %EVR
Provides: %{oname}-devel = %EVR

%description
Eigen is a C++ template library for linear algebra: matrices, vectors,
numerical solvers, and related algorithms.

%package docs
Summary: Documentation for Eigen3
Group: Development/Documentation
BuildArch: noarch
#BuildArch: noarch

%description docs
Eigen is a C++ template library for linear algebra: matrices, vectors,
numerical solvers, and related algorithms.

This package contains development documentation for Eigen.

%package examples
Summary: Examples for Eigen3
Group: Development/Documentation

%description examples
Eigen is a C++ template library for linear algebra: matrices, vectors,
numerical solvers, and related algorithms.

This package contains examples for Eigen.

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p0 -b .fixcmake
%ifarch %e2k
%patch3 -p2 -b .e2k
%endif

%build
mkdir -p BUILD
pushd BUILD

%add_optflags -I%_includedir/metis
export PATH=$PATH:%_libdir/pastix/bin

cmake \
	-DCMAKE_INSTALL_PREFIX=%prefix \
	-DCMAKE_C_FLAGS="%optflags" \
	-DCMAKE_CXX_FLAGS="%optflags" \
	-DCMAKE_Fortran_FLAGS="%optflags" \
%ifarch %e2k
	-DEIGEN_TEST_AVX512:BOOL=OFF \
	-DEIGEN_TEST_AVX:BOOL=OFF \
	-DEIGEN_TEST_SSE4_2:BOOL=OFF \
%else
	-DCHOLMOD_INCLUDES:PATH=%_includedir/suitesparse \
	-DUMFPACK_INCLUDES:PATH=%_includedir/suitesparse \
%endif
%if_disabled qt4
	-DEIGEN_TEST_NOQT=ON \
%endif
	-DSUPERLU_LIBRARIES:STRING=-lsuperlu_4.0 \
	-DCMAKE_STRIP:FILEPATH="/bin/echo" \
	-DCMAKE_VERBOSE_MAKEFILE:BOOL=ON \
	-DEIGEN_INCLUDE_INSTALL_DIR:PATH=%_includedir/%name \
	-DGOOGLEHASH_INCLUDES:PATH="%_includedir/google" \
	-DGOOGLEHASH_COMPILE:STRING="g++ %optflags" \
	-DPKGCONFIG_INSTALL_DIR=%_pkgconfigdir \
	..
popd

%make_build -C BUILD
%ifnarch %e2k
%make_build -C BUILD doc
%endif

%install
%makeinstall_std -C BUILD

install -d %buildroot%_bindir
%ifnarch %e2k
rm -fR BUILD/doc/examples/CMakeFiles BUILD/doc/examples/*.out \
	BUILD/doc/examples/*.cmake
install -m755 BUILD/doc/examples/* %buildroot%_bindir
%endif

%files
%_includedir/*
%_pkgconfigdir/*
%_datadir/cmake/Modules/FindEigen3.cmake
%_datadir/%name/cmake/*.cmake

%ifnarch %e2k
%files examples
%_bindir/*
%doc doc/examples/*

%files docs
%doc BUILD/doc/html/*
%endif

%changelog
