Name: element-desktop
Version: 1.8.5
Release: alt1

Summary: A glossy Matrix collaboration client

License: Apache 2.0
Url: https://element.io/
Group: Networking/Instant messaging

BuildArch: noarch

# Source-url: https://github.com/vector-im/element-desktop/archive/v%version.tar.gz
Source: %name-%version.tar

# auto predownloaded node modules during update version with rpmgs from etersoft-build-utils
# ask me about description using: lav@etersoft.ru
Source1: %name-development-%version.tar

Source3: %name.desktop

AutoReq:yes,nonodejs,nonodejs_native,nomono,nopython,nomingw32,nomingw64,noshebang
#AutoProv: no

ExclusiveArch: x86_64 aarch64

BuildRequires: npm node-asar
# https://github.com/yarnpkg/yarn/issues/7251
BuildRequires: /proc yarn

BuildRequires: element-web = %version

Requires: electron13 >= 13.1.9

Provides: riot-desktop = %version-%release
Obsoletes: riot-desktop

BuildRequires: node-typescript

%description
Element Desktop is a Matrix client for desktop platforms with Element Web at its core.

%prep
%setup -a1
cp -a /var/www/html/element-web webapp

%build
# note: configure it
cat element.io/release/config.json | grep -v "update_base_url" > webapp/config.json
# TODO: support hak and build matrix-seshat
#yarn run hak
yarn run build:ts
yarn run build:res
#npm run build
#yarn build
#yarn dist
#npm ERR! cb() never called!
#npm ERR! This is an error with npm itself. Please report this error at:
rm -vf node_modules/.bin/{npm,npx}
npm prune --production

asar pack . resources/app.asar

cat <<EOF >%name
#!/bin/sh
electron13 %_datadir/%name/resources/app.asar "\$@"
EOF

%install
install -m755 -D %name %buildroot%_bindir/%name
ln -s %name %buildroot/%_bindir/riot-desktop

mkdir -p %buildroot%_datadir/%name/
cp -a resources %buildroot%_datadir/%name/

for i in 16 22 24 32 48 64 128 256 512 ; do
    F=build/icons/${i}x${i}.png
    [ -s "$F" ] || continue
    T=%buildroot%_iconsdir/hicolor/${i}x${i}/apps/
    mkdir -p $T/
    cp $F $T/%name.png
done

install -D -m644 %SOURCE3 %buildroot%_desktopdir/%name.desktop

%files
%_bindir/riot-desktop
%_bindir/%name
%_datadir/%name/
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*/apps/*

%changelog
