%def_disable snapshot

%def_enable video
%def_enable webready
%def_enable tests
%def_disable ssh
%def_disable check

Name: exiv2
Version: 0.27.3
Release: alt1

Summary: Command line tool to access EXIF data in image files
License: GPL-2.0-or-later
Group: Graphics
Url: http://www.exiv2.org

%if_disabled snapshot
#Source: %url/builds/%name-%version-Source.tar.gz
Source: https://github.com/Exiv2/%name/archive/v%version/%name-%version.tar.gz
%else
#VCS: https://github.com/Exiv2/exiv2.git
Source: %name-%version.tar
%endif
# aarch64, armh, ppc64le:
# cc1plus: error: '-fcf-protection=full' is not supported for this target
Patch: %name-0.27.3-alt-no-fcf-protection.patch

Requires: lib%name = %version-%release

BuildRequires(pre): cmake
BuildRequires: gcc-c++ libexpat-devel zlib-devel
BuildRequires: doxygen xsltproc graphviz
%{?_enable_tests:BuildRequires: libgtest-devel}
%{?_enable_webready:BuildRequires: libcurl-devel libssh-devel libgcrypt-devel}
%{?_enable_check:BuildRequires: ctest}

%description
Exiv2 comprises of a C++ library and a command line utility to access
image metadata. Exiv2 supports full read and write access to the EXIF and
IPTC metadata, EXIF MakerNote support, extract and delete methods for
EXIF thumbnails, classes to access IFD and so on.

%package -n libexiv2
Summary: EXIF and IPTC metadata manipulation library
Group: Graphics

%description -n libexiv2
libexiv2 is a C++ library to access image metadata.

%package -n libexiv2-devel
Summary: Headers and links to compile against the exiv2 library
Group: Development/C
Requires: libexiv2 = %version-%release

%description -n libexiv2-devel
This package contains all files which one needs to compile programs using the
exiv2 library.

%prep
%setup -n %name-%version
%ifnarch %ix86 x86_64
%patch
%endif

%build
# xmpsdk: embedded copy of exempi should be compiled with BanAllEntityUsage
# https://bugzilla.redhat.com/show_bug.cgi?id=888769
export CPPFLAGS="$CPPFLAGS -DBanAllEntityUsage=1"
export MAKEFILES_TYPE='Unix Makefiles'
%add_optflags %(getconf LFS_CFLAGS)
%cmake -G "$MAKEFILES_TYPE" \
	-DCMAKE_BUILD_TYPE="Release" \
	-DBUILD_STATIC_LIBS=OFF \
	-DEXIV2_BUILD_SAMPLES=OFF \
	%{?_enable_video:-DEXIV2_ENABLE_VIDEO=ON} \
	%{?_enable_webready:-DEXIV2_ENABLE_WEBREADY=ON} \
	%{?_enable_ssh:-DEXIV2_ENABLE_SSH=ON} \
	%{?_enable_tests:-DEXIV2_BUILD_UNIT_TESTS=ON}
%cmake_build

%install
%cmakeinstall_std
%find_lang exiv2

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%make -C BUILD tests

%files
%_bindir/%name
%_man1dir/*
%doc README* doc/ChangeLog

%files -n libexiv2 -f exiv2.lang
%_libdir/lib%name.so.*

%files -n libexiv2-devel
%_libdir/lib%name.so
%_libdir/libexiv2-xmp.a
%_includedir/%name/
%_pkgconfigdir/%name.pc
%_libdir/cmake/%name/


%changelog
