%define _unpackaged_files_terminate_build 1

%define mpiimpl openmpi
%define mpidir %_libdir/%mpiimpl

Name: exodusii
Version: 6.09.0
%define somver 0
%define sover %somver.%version
Release: alt2.git20150119
Summary: A model developed to store and retrieve transient data for finite element analyses
License: BSD
Group: Sciences/Mathematics
Url: http://sourceforge.net/projects/exodusii/

ExclusiveArch: %ix86 x86_64

# git://exodusii.git.sourceforge.net/gitroot/exodusii/exodusii
Source: %name-%version.tar
Source1: CMakeCache.txt

BuildPreReq: doxygen graphviz
BuildPreReq: %mpiimpl-devel cmake libnetcdf-mpi-devel imake
BuildPreReq: netcdf11-mpi-tools libhdf5-mpi-devel
BuildPreReq: libcurl-devel

%description
EXODUS II is a model developed to store and retrieve transient data for
finite element analyses. It is used for preprocessing, postprocessing,
as well as code to code data transfer. ExodusII is based on netcdf.
Includes the nemesis parallel extension.

%package -n lib%name
Summary: Shared libraries of EXODUS II
Group: System/Libraries
Requires: libnetcdf11-mpi

%description -n lib%name
EXODUS II is a model developed to store and retrieve transient data for
finite element analyses. It is used for preprocessing, postprocessing,
as well as code to code data transfer. ExodusII is based on netcdf.
Includes the nemesis parallel extension.

This package contains shared libraries of EXODUS II.

%package -n lib%name-devel
Summary: Development files of EXODUS II
Group: Development/C++
Requires: lib%name = %EVR

%description -n lib%name-devel
EXODUS II is a model developed to store and retrieve transient data for
finite element analyses. It is used for preprocessing, postprocessing,
as well as code to code data transfer. ExodusII is based on netcdf.
Includes the nemesis parallel extension.

This package contains development files of EXODUS II.

%package -n lib%name-devel-doc
Summary: Documentation for EXODUS II
Group: Development/Documentation
BuildArch: noarch

%description -n lib%name-devel-doc
EXODUS II is a model developed to store and retrieve transient data for
finite element analyses. It is used for preprocessing, postprocessing,
as well as code to code data transfer. ExodusII is based on netcdf.
Includes the nemesis parallel extension.

This package contains development documentation for EXODUS II.

%package -n python-module-exodus
Summary: Python binding for EXODUS II
Group: Development/Python
Requires: lib%name = %EVR

%description -n python-module-exodus
EXODUS II is a model developed to store and retrieve transient data for
finite element analyses. It is used for preprocessing, postprocessing,
as well as code to code data transfer. ExodusII is based on netcdf.
Includes the nemesis parallel extension.

This package contains python binding for EXODUS II.

%prep
%setup
install -p -m644 %SOURCE1 exodus
install -p -m644 %SOURCE1 nemesis
%ifarch x86_64
LIB64=64
%endif
sed -i "s|@64@|$LIB64|g" exodus/CMakeCache.txt nemesis/CMakeCache.txt
sed -i "s|@PWD@|$PWD|g" exodus/CMakeCache.txt nemesis/CMakeCache.txt

%build
mpi-selector --set %mpiimpl
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib"

pushd exodus
cmake \
%ifarch x86_64
	-DLIB_SUFFIX:STRING="64" \
%endif
	-DSOMVER:STRING="%somver" \
	-DSOVER:STRING="%sover" \
	-DNETCDF_SO_ROOT=%_libdir \
	-DPYTHON_INSTALL=%python_sitelibdir \
	.
%make_build VERBOSE=1
popd
pushd nemesis
cmake \
%ifarch x86_64
	-DLIB_SUFFIX:STRING="64" \
%endif
	-DSOMVER:STRING="%somver" \
	-DSOVER:STRING="%sover" \
	.
%make_build VERBOSE=1
popd

pushd exodus
doxygen
popd

%install
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib"

pushd exodus
%makeinstall_std
popd
pushd nemesis
%makeinstall_std
popd

install -d %buildroot%_includedir/%name
mv %buildroot%_includedir/*.h %buildroot%_includedir/%name/

mv nemesis/README README.Nemesis

%filter_from_requires /^debug.*(libnetcdf\.so.*/s/^/libnetcdf11-mpi-debuginfo\t/
%filter_from_requires /^debug.*(libhdf5\.so.*/s/^/libhdf5-8-mpi-debuginfo\t/

%files -n lib%name
%doc exodus/COPYRIGHT exodus/README README.Nemesis ChangeLog
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*

%files -n lib%name-devel-doc
#doc exodus/html exodus/doc/* nemesis/doc/*
%doc exodus/html exodus/doc/*

%files -n python-module-exodus
%python_sitelibdir/*

%changelog
