%set_automake_version 1.11

Name: fftw
Version: 2.1.5
Release: alt8

Summary: Fast Fourier transform library
License: GPL
Group: System/Libraries
Url: http://www.fftw.org

Source: fftw-%version.tar
Patch0: fftw-2.1.5-pentium.patch
Patch1: fftw-2.1.5-alt-texinfo.patch
Patch2: fftw-2.1.5-alt-link_no_undefined.patch

BuildRequires: gcc-fortran makeinfo

%description
FFTW is a collection of fast C routines for computing the Discrete Fourier
Transform in one or more dimensions.  It includes complex, real, and
parallel transforms, and can handle arbitrary array sizes efficiently.
This RPM package includes both the double- and single-precision FFTW
uniprocessor and threads libraries.  (The single-precision files have
an "s" prefix.)

%package -n lib%name
Summary: Dynamic libraries for FFTW fast fourier transform library
Group: System/Libraries

%description -n lib%name
FFTW is a collection of fast C routines for computing the Discrete Fourier
Transform in one or more dimensions.  It includes complex, real, and
parallel transforms, and can handle arbitrary array sizes efficiently.
This RPM package includes both the double- and single-precision FFTW
uniprocessor and threads libraries.  (The single-precision files have
an "s" prefix.)

%package -n lib%name-devel
Summary: Headers, libraries, & docs for FFTW fast fourier transform library
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package contains the additional header files, documentation, and
libraries you need to develop programs using the FFTW fast fourier
transform library.

%package -n lib%name-devel-static
Summary: Static libraries for FFTW fast fourier transform library
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
This package contains static libraries you need to develop programs using
the FFTW fast fourier transform library.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1

# sources came with pre-generated config.h :-(
rm fftw/config.h

# create two separate build directories within main dir
mkdir -p double single

%build
aclocal
automake
autoconf
libtoolize --copy --force

%global _configure_script ../configure

%ifarch %ix86
%define arch_options --enable-i386-hacks
%else
%define arch_options %nil
%endif

pushd double
%configure --enable-shared --enable-threads %arch_options
%make
popd

pushd single
%configure --enable-shared --enable-threads %arch_options \
	--enable-float --enable-type-prefix
%make
popd

%install
# The double-precision version is installed with the normal library names,
# while the single-precision version is installed with an "s" prefix.
%makeinstall -C double
%makeinstall -C single

%files -n lib%name
%doc AUTHORS NEWS README
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_infodir/*.info*
%_libdir/*.so

%files -n lib%name-devel-static
%_libdir/*.a

%changelog
