%global _firmwarepath  /lib/firmware
Summary: Firmware and topology files for Sound Open Firmware project
Name: firmware-alsa-sof
Version: 1.8
Release: alt4
# See later in the spec for a breakdown of licensing
License: BSD
Group: Sound
Url: https://github.com/thesofproject/sof-bin
BuildRequires: alsa-utils alsa-topology-conf
Source: %name-%version.tar
Source2: sof-glk-es8336-ssp0.tplg
Provides: alsa-sof-firmware = %EVR
# noarch, since the package is firmware
BuildArch: noarch

%description
This package contains the firmware binaries for the Sound Open Firmware project.

%package debug
Requires: alsa-sof-firmware
Summary: Debug files for Sound Open Firmware project
Group: Sound

%description debug
This package contains the debug files for the Sound Open Firmware project.

%prep
%setup

%build
# build generic topology file from alsa-topology
alsatplg -c /usr/share/alsa/topology/hda-dsp/skl_hda_dsp_generic-tplg.conf \
         -o skl_hda_dsp_generic-tplg.bin

%install
mkdir -p  %buildroot%_firmwarepath/intel/
cp -a v%version.x/sof-tplg-v%version  %buildroot%_firmwarepath/intel/sof-tplg-v%version
install %SOURCE2 %buildroot%_firmwarepath/intel/sof-tplg-v%version/
cp -a v%version.x/sof-v%version  %buildroot%_firmwarepath/intel/sof
ln -s sof-tplg-v%version %buildroot%_firmwarepath/intel/sof-tplg
install -m0644 skl_hda_dsp_generic-tplg.bin %buildroot%_firmwarepath/

# gather files and directories
FILEDIR=$(pwd)
pushd %buildroot/%_firmwarepath
# remove all broken symlinks
find . -xtype l -type l -print -delete
find -P . -name "*.ri" | sed -e '/^.$/d' > $FILEDIR/alsa-sof-firmware.files
find -P . -name "*.tplg" | sed -e '/^.$/d' >> $FILEDIR/alsa-sof-firmware.files
find -P . -name "*.ldc" | sed -e '/^.$/d' > $FILEDIR/alsa-sof-firmware.debug-files
find -P . -type d | sed -e '/^.$/d' > $FILEDIR/alsa-sof-firmware.dirs
popd
sed -i -e 's:^./::' alsa-sof-firmware.{files,debug-files,dirs}
sed -i -e 's!^!/lib/firmware/!' alsa-sof-firmware.{files,debug-files,dirs}
sed -e 's/^/%%dir /' alsa-sof-firmware.dirs >> alsa-sof-firmware.files
cat alsa-sof-firmware.files

%files -f alsa-sof-firmware.files
%doc LICENCE*  README*
%dir %_firmwarepath
%_firmwarepath/skl_hda_dsp_generic-tplg.bin
%dir %_firmwarepath/intel
%_firmwarepath/intel/sof-tplg



%files debug -f alsa-sof-firmware.debug-files

%changelog
