Name: fotoxx
Version: 19.17
Release: alt1

Summary: Software for digital image editing, HDR composites, and panoramas
License: GPLv3+
Group: Graphics
Url: http://www.kornelix.com/%name/%name.html

# VCS: https://gitlab.com/fotoxx/fotoxx.git
Source: http://www.kornelix.com/downloads/downloads/%name-%version.tar.gz
Source1: fotoxx.desktop
Source2: fotoxx16.png
Source3: fotoxx32.png

Requires: %name-data = %version-%release

# fotoxx uses exiv2 executable to read EXIF data:
Requires: exiv2
# fotoxx uses xdg-open executable to launch HTML docs viewer:
Requires: xdg-utils

# needed to write images to CD/DVD
Requires: brasero

Provides: fotox
Obsoletes: fotox

BuildRequires: gcc-c++ libgtk+3-devel libtiff-devel libjpeg-devel liblcms2-devel
BuildRequires: perl-Image-ExifTool xdg-utils
BuildRequires: libchamplain-gtk3-devel libclutter-gtk3-devel libappstream-glib-devel
BuildRequires: libraw-devel

%description
Fotox is a program for improving digital photos. Navigate through large image
directories using a window of thumbnail images. Create HDR (high dynamic range)
images by combining bright and dark images to improve details visible in both
bright and dark areas. Create panorama (extra wide) images by joining overlapped
images. Adjust brightness and color intensity independently for different
underlying brightness levels. Reduce fog or haze by removing "whiteness" and
intensifying colors. Rotate an image (level a tilted image or turn 90 degrees).
Remove the red-eye effect from electronic flash photos. Resize or crop an image.

%package data
Summary: Arch independent files for Fotox
Group: Graphics
BuildArch: noarch

%description data
This package provides noarch data needed for Fotox to work.

%prep
%setup -n %name
chmod -x doc/*

%build
%make_build PREFIX=/usr CXXFLAGS="%optflags -D_FILE_OFFSET_BITS=64"

%install
install -d %buildroot%_man1dir
%make_install install DESTDIR=%buildroot PREFIX=%_prefix

install -pD -m644 %SOURCE1 %buildroot%_desktopdir/fotoxx.desktop
install -pD -m644 doc/fotoxx.man %buildroot%_man1dir/fotoxx.1
install -pD -m644 images/fotoxx.png %buildroot%_liconsdir/fotoxx.png
install -pD %_sourcedir/fotoxx32.png %buildroot%_niconsdir/fotoxx.png
install -pD %_sourcedir/fotoxx16.png %buildroot%_miconsdir/fotoxx.png

%files
%_bindir/%name

%files data
%_desktopdir/*
%_miconsdir/*
%_niconsdir/*
%_liconsdir/*
%_datadir/%name/
%_man1dir/*
%_datadir/appdata/%name.appdata.xml
%doc doc/README* doc/changelog doc/copyright

%exclude %_datadir/doc/%name

%changelog
